/*
 * Decompiled with CFR 0.152.
 */
package agents.andySloane;

import agents.andySloane.MarioState;
import agents.andySloane.MarioStateComparator;
import java.util.Arrays;

public class PrioQ {
    private static MarioStateComparator comparator = new MarioStateComparator();
    private MarioState[] queue;
    private int size = 0;

    public PrioQ(int n) {
        this.queue = new MarioState[n];
    }

    public boolean offer(MarioState marioState) {
        if (marioState == null) {
            throw new NullPointerException();
        }
        if (this.size == this.queue.length) {
            this.drop();
        }
        int n = this.size;
        this.size = n + 1;
        if (n == 0) {
            this.queue[0] = marioState;
        } else {
            this.siftUp(n, marioState);
        }
        return true;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.queue[i] = null;
        }
        this.size = 0;
    }

    public MarioState peek() {
        if (this.size == 0) {
            return null;
        }
        return this.queue[0];
    }

    public MarioState poll() {
        if (this.size == 0) {
            return null;
        }
        int n = --this.size;
        MarioState marioState = this.queue[0];
        MarioState marioState2 = this.queue[n];
        this.queue[n] = null;
        if (n != 0) {
            this.siftDown(0, marioState2);
        }
        return marioState;
    }

    public void drop() {
        int n;
        Arrays.sort(this.queue, 0, this.size, comparator);
        int n2 = this.size >> 1;
        for (n = 0; n < n2; ++n) {
            this.queue[--this.size] = null;
        }
        for (n = (this.size >>> 1) - 1; n >= 0; --n) {
            this.siftDown(n, this.queue[n]);
        }
    }

    private void siftUp(int n, MarioState marioState) {
        int n2;
        MarioState marioState2;
        while (n > 0 && this.compare(marioState, marioState2 = this.queue[n2 = n - 1 >>> 1]) < 0) {
            this.queue[n] = marioState2;
            n = n2;
        }
        this.queue[n] = marioState;
    }

    private void siftDown(int n, MarioState marioState) {
        int n2 = this.size >>> 1;
        while (n < n2) {
            int n3 = (n << 1) + 1;
            MarioState marioState2 = this.queue[n3];
            int n4 = n3 + 1;
            if (n4 < this.size && this.compare(marioState2, this.queue[n4]) > 0) {
                n3 = n4;
                marioState2 = this.queue[n3];
            }
            if (this.compare(marioState, marioState2) <= 0) break;
            this.queue[n] = marioState2;
            n = n3;
        }
        this.queue[n] = marioState;
    }

    private int compare(MarioState marioState, MarioState marioState2) {
        if (marioState.cost < marioState2.cost) {
            return -1;
        }
        if (marioState.cost > marioState2.cost) {
            return 1;
        }
        return 0;
    }
}

