/*
 * Decompiled with CFR 0.152.
 */
package agents.sergeyPolikarpov;

import java.util.Random;

public class CyberNeuron {
    private float[][][] sbox;
    private int[] inputs_for_sbox;
    private int[] outputs_for_sbox;
    private double[] outputs;
    private double[] inputs;
    public final int parallel_inputs = 1;
    private int num_bits_in_input = 10;
    private int num_of_cells_in_sbox = (int)Math.pow(2.0, this.num_bits_in_input);
    private int[] powstwo = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536};
    private int threshold;
    private final Random random = new Random();
    private double learningRate = 0.05;

    public CyberNeuron(int n, int n2) {
        this.threshold = (int)(0.65 * (double)(127 * n * 1 / this.num_bits_in_input));
        this.sbox = new float[n * 1 / this.num_bits_in_input][this.num_of_cells_in_sbox][n2];
        this.inputs_for_sbox = new int[this.sbox.length];
        this.outputs_for_sbox = new int[this.sbox[0][0].length];
        this.outputs = new double[n2];
        this.inputs = new double[n];
        this.initialize_sbox(this.sbox);
    }

    public CyberNeuron(float[][][] fArray, int n) {
        this.sbox = fArray;
        this.inputs = new double[fArray.length * this.num_bits_in_input];
        this.outputs = new double[n];
    }

    protected void initialize_sbox(float[][][] fArray) {
        for (int i = 0; i < fArray.length; ++i) {
            for (int j = 0; j < fArray[i].length; ++j) {
                for (int k = 0; k < fArray[i][j].length; ++k) {
                    fArray[i][j][k] = 0.0f;
                }
            }
        }
    }

    public CyberNeuron getNewInstance() {
        return new CyberNeuron(this.sbox.length * this.num_bits_in_input / 1, this.outputs.length);
    }

    public CyberNeuron copy() {
        CyberNeuron cyberNeuron = new CyberNeuron(this.copy(this.sbox), this.outputs.length);
        return cyberNeuron;
    }

    private float[][][] copy(float[][][] fArray) {
        float[][][] fArray2 = new float[fArray.length][fArray[0].length][fArray[0][0].length];
        for (int i = 0; i < fArray2.length; ++i) {
            for (int j = 0; j < fArray2[i].length; ++j) {
                for (int k = 0; k < fArray2[i][j].length; ++k) {
                    fArray2[i][j][k] = fArray[i][j][k];
                }
            }
        }
        return fArray2;
    }

    public double[] propagate(double[] dArray) {
        int n;
        int n2;
        if (this.inputs != dArray) {
            System.arraycopy(dArray, 0, this.inputs, 0, dArray.length);
        }
        if (dArray.length < this.inputs.length) {
            System.out.println("NOTE: only " + dArray.length + " inputs out of " + this.inputs.length + " are used in the network");
        }
        int n3 = this.sbox.length / 1;
        int[] nArray = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = 0;
            for (n = 0; n < this.num_bits_in_input; ++n) {
                if (this.inputs[n2 * this.num_bits_in_input + n] != 1.0) continue;
                int n4 = n2;
                nArray[n4] = nArray[n4] + this.powstwo[n];
            }
        }
        for (n2 = 0; n2 < 1; ++n2) {
            for (n = 0; n < n3; ++n) {
                this.inputs_for_sbox[n2 * n3 + n] = nArray[n];
            }
        }
        for (n2 = 0; n2 < this.sbox[0][0].length; ++n2) {
            this.outputs_for_sbox[n2] = 0;
            for (int i = 0; i < this.sbox.length; ++i) {
                int n5 = n2;
                this.outputs_for_sbox[n5] = (int)((float)this.outputs_for_sbox[n5] + this.sbox[i][this.inputs_for_sbox[i]][n2]);
            }
            double d = this.outputs_for_sbox[n2] > this.threshold ? (double)this.threshold : (double)this.outputs_for_sbox[n2];
            this.outputs[n2] = d / (double)this.threshold;
        }
        return this.outputs;
    }

    public double backPropagate(double[] dArray) {
        int n;
        int n2;
        double[] dArray2 = new double[this.outputs.length];
        for (n2 = 0; n2 < dArray.length; ++n2) {
            dArray2[n2] = (dArray[n2] - this.outputs[n2]) * (double)this.threshold;
            if (!Double.isNaN(dArray2[n2])) continue;
            System.out.println("Problem at output " + n2);
            System.out.println(this.outputs[n2] + " " + dArray[n2]);
            System.exit(0);
        }
        for (n2 = 0; n2 < this.sbox[0][0].length; ++n2) {
            int n3;
            int n4;
            int n5 = (int)(dArray2[n2] * this.learningRate);
            if (n5 == 0) {
                if (dArray2[n2] > 0.0) {
                    dArray2[n2] = 1.0;
                }
                if (dArray2[n2] < 0.0) {
                    dArray2[n2] = -1.0;
                }
                if (dArray2[n2] == 0.0) {
                    dArray2[n2] = 0.0;
                }
            } else {
                dArray2[n2] = n5;
            }
            if (dArray2[n2] > 0.0) {
                n = 0;
                while ((double)n < dArray2[n2]) {
                    n4 = this.random.nextInt(this.sbox.length);
                    n3 = this.inputs_for_sbox[n4];
                    float[] fArray = this.sbox[n4][n3];
                    int n6 = n2;
                    fArray[n6] = fArray[n6] + 1.0f;
                    ++n;
                }
                continue;
            }
            n = 0;
            while ((double)n < Math.abs(dArray2[n2])) {
                n4 = this.random.nextInt(this.sbox.length);
                n3 = this.inputs_for_sbox[n4];
                float[] fArray = this.sbox[n4][n3];
                int n7 = n2;
                fArray[n7] = fArray[n7] - 1.0f;
                ++n;
            }
        }
        double d = 0.0;
        for (n = 0; n < dArray.length; ++n) {
            d += Math.abs(dArray[n] - this.outputs[n]);
        }
        return d /= (double)this.outputs.length;
    }

    public double getMutationMagnitude() {
        return 0.0;
    }

    public void setMutationMagnitude(double d) {
    }

    public static void setInitParameters(double d, double d2) {
        System.out.println("PARAMETERS SET: " + d + "  deviation: " + d2);
    }

    public void println() {
        System.out.print("\n\n---------------------------------------------------------------------------------------\n");
        System.out.print("---------------------------------------------------------------------------------------\n");
    }

    public String toString() {
        return "CyberNeuron by Sergey V. Polikarpov";
    }

    public void ssetLearningRate(double d) {
        this.learningRate = d;
    }

    public double[] getOutputs() {
        double[] dArray = new double[this.outputs.length];
        System.arraycopy(this.outputs, 0, dArray, 0, this.outputs.length);
        return dArray;
    }

    public double[] getWeightsArray() {
        double[] dArray = new double[this.sbox.length * this.sbox[0].length * this.sbox[0][0].length];
        int n = 0;
        for (int i = 0; i < this.sbox.length; ++i) {
            for (int j = 0; j < this.sbox[i].length; ++j) {
                for (int k = 0; k < this.sbox[i][j].length; ++k) {
                    n = i + j + k;
                    dArray[n] = this.sbox[i][j][k];
                }
            }
        }
        return dArray;
    }

    public void setWeightsArray(double[] dArray) {
        int n = 0;
        for (int i = 0; i < this.sbox.length; ++i) {
            for (int j = 0; j < this.sbox[i].length; ++j) {
                for (int k = 0; k < this.sbox[i][j].length; ++k) {
                    n = i + j + k;
                    this.sbox[i][j][k] = (char)dArray[n];
                }
            }
        }
    }

    public int getNumberOfInputs() {
        return this.inputs.length;
    }

    public void randomise() {
    }

    public double[] getArray() {
        return this.getWeightsArray();
    }

    public void setArray(double[] dArray) {
        this.setWeightsArray(dArray);
    }

    public int[] getPackedInputsToInt(double[] dArray) {
        int[] nArray = new int[this.sbox.length];
        for (int i = 0; i < this.sbox.length; ++i) {
            nArray[i] = 0;
            for (int j = 0; j < this.num_bits_in_input; ++j) {
                if (dArray[i * this.num_bits_in_input + j] != 1.0) continue;
                int n = i;
                nArray[n] = nArray[n] + this.powstwo[j];
            }
        }
        return nArray;
    }
}

