/*
 * Decompiled with CFR 0.152.
 */
package engine.helper;

import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;

public class Assets {
    public static Image[][] mario;
    public static Image[][] smallMario;
    public static Image[][] fireMario;
    public static Image[][] enemies;
    public static Image[][] items;
    public static Image[][] level;
    public static Image[][] particles;
    public static Image[][] font;
    public static Image[][] map;
    static final String curDir;
    static final String img;

    public static void init(GraphicsConfiguration graphicsConfiguration) {
        try {
            mario = Assets.cutImage(graphicsConfiguration, "mariosheet.png", 32, 32);
            smallMario = Assets.cutImage(graphicsConfiguration, "smallmariosheet.png", 16, 16);
            fireMario = Assets.cutImage(graphicsConfiguration, "firemariosheet.png", 32, 32);
            enemies = Assets.cutImage(graphicsConfiguration, "enemysheet.png", 16, 32);
            items = Assets.cutImage(graphicsConfiguration, "itemsheet.png", 16, 16);
            level = Assets.cutImage(graphicsConfiguration, "mapsheet.png", 16, 16);
            particles = Assets.cutImage(graphicsConfiguration, "particlesheet.png", 16, 16);
            font = Assets.cutImage(graphicsConfiguration, "font.gif", 8, 8);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static Image getImage(GraphicsConfiguration graphicsConfiguration, String string) throws IOException {
        Object object;
        Object object2;
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(Assets.class.getResourceAsStream(string));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bufferedImage == null) {
            string = img + string;
            object2 = new File(string);
            bufferedImage = ImageIO.read((File)object2);
        }
        if (bufferedImage == null) {
            object2 = new File(string);
            object = ImageIO.createImageInputStream(object2);
            String string2 = string.substring(string.length() - 3);
            ImageReader imageReader = ImageIO.getImageReadersBySuffix(string2).next();
            imageReader.setInput(object, true);
            bufferedImage = imageReader.read(0);
        }
        object2 = graphicsConfiguration.createCompatibleImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
        object = (Graphics2D)((Image)object2).getGraphics();
        ((Graphics2D)object).setComposite(AlphaComposite.Src);
        ((Graphics)object).drawImage(bufferedImage, 0, 0, null);
        ((Graphics)object).dispose();
        return object2;
    }

    private static Image[][] cutImage(GraphicsConfiguration graphicsConfiguration, String string, int n, int n2) throws IOException {
        Image image = Assets.getImage(graphicsConfiguration, string);
        Image[][] imageArray = new Image[image.getWidth(null) / n][image.getHeight(null) / n2];
        for (int i = 0; i < image.getWidth(null) / n; ++i) {
            for (int j = 0; j < image.getHeight(null) / n2; ++j) {
                BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 2);
                Graphics2D graphics2D = (Graphics2D)((Image)bufferedImage).getGraphics();
                graphics2D.setComposite(AlphaComposite.Src);
                graphics2D.drawImage(image, -i * n, -j * n2, null);
                graphics2D.dispose();
                imageArray[i][j] = bufferedImage;
            }
        }
        return imageArray;
    }

    static {
        curDir = System.getProperty("user.dir");
        img = curDir + "/img/";
    }
}

