/*
 * Decompiled with CFR 0.152.
 */
package levelGenerators.random;

import engine.core.MarioLevelGenerator;
import engine.core.MarioLevelModel;
import engine.core.MarioTimer;
import java.util.Random;

public class LevelGenerator
implements MarioLevelGenerator {
    private final int GROUND_Y_LOCATION = 13;
    private final float GROUND_PROB = 0.4f;
    private final int OBSTACLES_LOCATION = 10;
    private final float OBSTACLES_PROB = 0.1f;
    private final int COLLECTIBLE_LOCATION = 3;
    private final float COLLECTIBLE_PROB = 0.05f;
    private final float ENMEY_PROB = 0.1f;
    private final int FLOOR_PADDING = 3;

    @Override
    public String getGeneratedLevel(MarioLevelModel marioLevelModel, MarioTimer marioTimer) {
        Random random = new Random();
        marioLevelModel.clearMap();
        for (int i = 0; i < marioLevelModel.getWidth(); ++i) {
            for (int j = 0; j < marioLevelModel.getHeight(); ++j) {
                marioLevelModel.setBlock(i, j, '-');
                if (j > 13) {
                    if (!(random.nextDouble() < (double)0.4f)) continue;
                    marioLevelModel.setBlock(i, j, 'X');
                    continue;
                }
                if (j > 10) {
                    if (random.nextDouble() < (double)0.1f) {
                        marioLevelModel.setBlock(i, j, '#');
                        continue;
                    }
                    if (!(random.nextDouble() < (double)0.1f)) continue;
                    marioLevelModel.setBlock(i, j, MarioLevelModel.getEnemyCharacters()[random.nextInt(MarioLevelModel.getEnemyCharacters().length)]);
                    continue;
                }
                if (j <= 3 || !(random.nextDouble() < (double)0.05f)) continue;
                marioLevelModel.setBlock(i, j, MarioLevelModel.getCollectablesTiles()[random.nextInt(MarioLevelModel.getCollectablesTiles().length)]);
            }
        }
        marioLevelModel.setRectangle(0, 14, 3, 2, 'X');
        marioLevelModel.setRectangle(marioLevelModel.getWidth() - 1 - 3, 14, 3, 2, 'X');
        marioLevelModel.setBlock(1, 13, 'M');
        marioLevelModel.setBlock(marioLevelModel.getWidth() - 1 - 1, 13, 'F');
        return marioLevelModel.getMap();
    }

    @Override
    public String getGeneratorName() {
        return "RandomLevelGenerator";
    }
}

