#!bin/bash

port=$(shuf -i25000-30000 -n1)
deepspeed --include=localhost:0,1,2,3,4,5,6,7 --master_port $port training/replay.py  \
    --data_path TRACE-Benchmark/LLM-CL-Benchmark_5000 \
    --dataset_name C-STANCE,FOMC,MeetingBank,Py150,ScienceQA,NumGLUE-cm,NumGLUE-ds,20Minuten \
    --replay_dataset_name Lima \
    --model_name_or_path models/llama-2-13b-chat-hf \
    --per_device_train_batch_size 1 \
    --max_prompt_len 1024 \
    --max_ans_len 512 \
    --learning_rate 1e-5 \
    --weight_decay 0. \
    --use_freeze \
    --num_train_epochs 5,3,7,5,3,5,5,7 \
    --gradient_accumulation_steps 16 \
    --lr_scheduler_type constant \
    --num_warmup_steps 0 \
    --seed 1234 \
    --zero_stage 3 \
    --deepspeed \
    --print_loss \
    --past_task_ratio 0.1 \
    --output_dir output/half-13b-replay