import os


# change parameters
model_name_or_path = "/root/paddlejob/workspace/env_run/huitingfeng/models/llama-2-13b-chat-hf"
inference_model_path = "/root/paddlejob/workspace/env_run/huitingfeng/TRACE-master/output/half-13b-replay"
inference_output_path = "/root/paddlejob/workspace/env_run/huitingfeng/TRACE-master/output/half-13b-replay/predictions"

# fix parameters
data_path = "/root/paddlejob/workspace/env_run/huitingfeng/TRACE-Benchmark/LLM-CL-Benchmark_5000"
inference_tasks = "C-STANCE,FOMC,MeetingBank,Py150,ScienceQA,NumGLUE-cm,NumGLUE-ds,20Minuten"
inference_batch = 1
max_prompt_len = 1024
max_ans_len = 512
seed = 1234
CL_method = "base"

for i in range(8):
    with open(f'scripts/gpu{i}.sh', 'w') as f:
        f.write(f'#!bin/bash\n')
        f.write(f"deepspeed --include=localhost:{i} --master_port $(shuf -i25000-30000 -n1) inference/infer_gpu{i}.py --data_path {data_path} --inference_tasks {inference_tasks} --model_name_or_path {model_name_or_path} --inference_model_path {inference_model_path} --inference_batch {inference_batch} --max_prompt_len {max_prompt_len} --seed {seed} --deepspeed --CL_method {CL_method} --inference_output_path {inference_output_path}")