#!bin/bash
port=$(shuf -i25000-30000 -n1)
deepspeed --include=localhost:0,2,3,4 --master_port $port training/main.py \
   --data_path TRACE-Benchmark/LLM-CL-Benchmark_5000 \
   --dataset_name C-STANCE,FOMC,MeetingBank,Py150,ScienceQA,NumGLUE-cm,NumGLUE-ds,20Minuten \
   --model_name_or_path models/llama-2-13b-chat-hf \
   --per_device_train_batch_size 2 \
   --max_prompt_len 1024 \
   --max_ans_len 512 \
   --learning_rate 1e-4 \
   --weight_decay 0. \
   --num_train_epochs 5,3,7,5,3,5,5,7 \
   --gradient_accumulation_steps 8 \
   --lr_scheduler_type constant \
   --num_warmup_steps 0 \
   --seed 1234 \
   --zero_stage 2 \
   --deepspeed \
   --print_loss \
   --CL_method lora \
   --output_dir output/lora-13b
