import numpy as np
import torch


# CAUTION: This has to be 1D because of broadcast semantics in kernel regression.
class Gaussian1D(torch.nn.Module):

    def __init__(self, bandwidth: float) -> None:
        super().__init__()
        self.bandwidth = bandwidth

    def forward(self, x: torch.FloatTensor):
        return (
            1
            / (self.bandwidth * np.sqrt(2 * np.pi))
            * torch.exp(-torch.square(x) / (2 * (self.bandwidth**2)))
        )

class Epanechnikov1D(torch.nn.Module):

    def __init__(self, bandwidth: float) -> None:
        super().__init__()
        self.bandwidth = bandwidth

    def forward(self, x: torch.FloatTensor):
        return 3/(4 * self.bandwidth) * (1 - (x / self.bandwidth) ** 2) * (torch.abs(x / self.bandwidth) <= 1)
