
library(MASS)
library(mvtnorm)
library(fairml)
library("Renvlp")
library(pracma)
library(transport)
library(T4transport)
library(dplyr)
library(ggplot2)



source("simstudy_functions.R",local=TRUE)





library(parallel)
library(foreach)
library(iterators)
library(doParallel)



Pack <- c("MASS", "mvtnorm", "fairml", "Renvlp", "pracma",
          "transport", "T4transport", "dplyr", "ggplot2")
cl <- makeCluster(8)
registerDoParallel(cl)

set.seed(123)
n <- 20000
p <- 100
p_corr <- 50
p_corr_dim <- 15
p_S <- 20
r_fair_levels <- seq(0.1, 0.5, by = 0.1)


######Normal setting
# random_matrix <- matrix(rnorm(p_S * p_S), nrow = p_S, ncol = p_S)
# A <- qr.Q(qr(t(random_matrix) %*% random_matrix))
# Q <- A[, 1:p_corr_dim]
# S_Q <- Q %*% t(Q)
#
# beta_SX <- matrix(rnorm(p_corr * p_S), p_corr, p_S) + 2
# beta_S <- matrix(rnorm(p_S), p_S, 1) + 1
# beta_X <- matrix(rnorm(p), p, 1) + 2





######Tdist Setting

random_matrix <- matrix(rt(p_S * p_S,df=3), nrow = p_S, ncol = p_S)
A <- qr.Q(qr(t(random_matrix) %*% random_matrix))
Q <- A[, 1:p_corr_dim]
S_Q <- Q %*% t(Q)

beta_SX <- matrix(rt(p_corr * p_S,df=3), p_corr, p_S) + 2
beta_S <- matrix(rt(p_S,df=3), p_S, 1) + 1
beta_X <- matrix(rnorm(p), p, 1) + 2


results_ols <- data.frame()
results_envelop <- data.frame()
results_envelop_intersec <- data.frame()



num_replicates<-30

Results1<-foreach(j = 1:num_replicates, .combine = 'rbind', .packages = Pack) %dopar% {
  result <- Process(n, p, p_corr, p_corr_dim, p_S, S_Q, beta_SX, beta_S, beta_X,r_fair_levels)


}


####n=5000


p = 40
p_S = 10
p_corr = 20
p_corr_dim = 5
n=5000
num_replicates=30
######Normal setting
random_matrix <- matrix(rnorm(p_S * p_S,sd=0.5), nrow = p_S, ncol = p_S)
A <- qr.Q(qr(t(random_matrix) %*% random_matrix))
Q <- A[, 1:p_corr_dim]
S_Q <- Q %*% t(Q)
beta_SX <- matrix(rnorm(p_corr * p_S,sd=0.5), p_corr, p_S) + 2
beta_S <- matrix(rnorm(p_S,sd=0.5), p_S, 1) + 1
beta_X <- matrix(rnorm(p,sd=0.5), p, 1) + 2
Results2<-foreach(j = 1:num_replicates, .combine = 'rbind', .packages = Pack) %dopar% {
  result <- Process(n, p, p_corr, p_corr_dim, p_S, S_Q, beta_SX, beta_S, beta_X,r_fair_levels)
}


# Summarize data to compute mean and standard deviation (for error bars)
filtered_data <- Results1 %>%
  filter(Method != "Komi")
filtered_data <- filtered_data %>%
  mutate(Method = case_when(
    Method == "Komi"  ~ "NCLM",
    Method == "OLS"   ~ "FRRM",
    Method == "Envelop" ~ "FERM(general)",
    Method == "Envelop_intersec" ~ "FERM(with S)",
    TRUE ~ Method  # Keep unchanged if not matched
  ))

ggplot(filtered_data, aes(x = factor(r_fair), y = Fair_SX_test, fill = Method)) +
  geom_boxplot() +
  labs(
    #title = "MSE_test Distribution by r_fair for Different Methods",
    x = "r",
    y = "Preditive MSE",
    fill = "Method"
  ) +
  theme_minimal() +
  theme(
    axis.text.x = element_text(angle = 45, hjust = 1),
    panel.background = element_rect(fill = "grey90", color = NA),  # Grey background
    #plot.background = element_rect(fill = "grey95", color = NA)   # Slightly lighter grey plot background
  )
ggplot(filtered_data, aes(x = factor(r_fair), y = MSE_test, fill = Method)) +
  geom_boxplot() +
  labs(
    #title = "MSE_test Distribution by r_fair for Different Methods",
    x = "r",
    y = "Preditive MSE",
    fill = "Method"
  ) +
  theme_minimal() +
  theme(
    axis.text.x = element_text(angle = 45, hjust = 1),
    panel.background = element_rect(fill = "grey90", color = NA),  # Grey background
    #plot.background = element_rect(fill = "grey95", color = NA)   # Slightly lighter grey plot background
  )


write.csv(Results1,file="result1.csv")

stopCluster(cl)


