
# Learning to Relative Expression under Batch Effects and Stochastic Noise in Spatial Transcriptomics
This repository is the official implementation of [Learning to Relative Expression under Batch Effects and Stochastic Noise in Spatial Transcriptomics]


![Concept](./figures/concept.png)

## Requirements

To install requirements:

```setup
pip install -r requirements.txt
```

## Training and evaluation on synthetic data
To train the model(s) in the paper, run this command:

```train and evaluation
cd toy_example
bash ./scripts/run_comparisons.sh
```

## Training and evaluation on real dataset
Data preparation:
Our experimetns used [Hest 1k](https://github.com/mahmoodlab/HEST/tree/main) dataset. Before execute our experiments, you should get permittion. 

Execute all experiments

```eval
python ./scripts/execute_all_exps.py
```

## Results

Our model achieves the following performance on :


**Table: Real dataset from Hest 1k. Bold = best performance, Underline = second-best. Ave. = average performance.**

|           | Loss        | IDC   | PRAD  | PAAD  | COAD  | READ  | ccRCC | IDC-L | Ave.  |
|-----------|-------------|-------|-------|-------|-------|--------|--------|--------|--------|
| **Point** | MSE         | 0.393 | 0.484 | 0.307 | 0.556 | 0.140 | 0.093 | 0.168 | 0.306 |
|           | Po          | 0.314 | _0.485_ | 0.336 | 0.524 | **0.172** | 0.091 | 0.134 | 0.293 |
|           | NB          | 0.199 | **0.491** | 0.119 | 0.538 | _0.160_ | 0.075 | 0.126 | 0.244 |
| **Pair**  | Rank        | 0.317 | 0.317 | 0.181 | 0.566 | 0.047 | 0.059 | 0.110 | 0.228 |
|           | PairSTrank  | _0.494_ | 0.458 | **0.346** | _0.613_ | 0.136 | **0.127** | _0.228_ | _0.343_ |
| **List**  | PCC         | 0.472 | 0.459 | 0.307 | **0.640** | 0.105 | 0.102 | 0.198 | 0.326 |
|           | ListSTrank  | **0.510** | 0.459 | _0.343_ | 0.597 | 0.140 | _0.125_ | **0.238** | **0.345** |



<!-- ## Contributing -->


## Acknowledgement
- We used [Hest 1k](https://github.com/mahmoodlab/HEST) dataset.
- For the feature extractor, we implemented the code based on [CLAM](https://github.com/mahmoodlab/CLAM).

