import json
with open('odds.jsonl', 'r') as f:
    entries = [json.loads(line) for line in f.readlines()]

for entry in entries:

    entry['options'] = {k: {cond: 1 - prob for cond, prob in v.items()} for k, v in entry['options'].items()}

with open('odds_flipped.jsonl', 'w') as f:
    for entry in entries:
        f.write(json.dumps(entry) + '\n')