# for parameter T, run get_baseline.py
# then run quality_judge.py
# then get_embeddings.py
# then run print_distances.py

#!/bin/bash

# Array of temperature values to test


# Create output directories if they don't exist
mkdir -p final_data/embeddings
mkdir -p final_data/quality_judge

# Process each temperature value
for T in 0 0.05 0.1 0.15 0.25 0.5 0.75 1.0 1.1 1.2 1.25 1.3 ; do
    echo "Processing temperature $T"
    
    # Run the pipeline for each temperature
    # python get_baseline.py $T; 
    # echo "Judge $T"
    python quality_judge.py --temperature $T --approach baseline --force True & 
    # echo "embedding $T"
    # python get_embeddings.py --temperature $T --approach baseline; 
done





