import os
import json
import fcntl
import time
import openai
from typing import List

def filter_seen_solutions(solutions, output_file):
    if os.path.exists(output_file):
        with open(output_file, 'r') as f:
            seen_prompts = [json.loads(line)['prompt'] for line in f.readlines()]
        return [sol for sol in solutions if sol['prompt'] not in seen_prompts]
    return solutions

def call_oai_rm_llm(
    prompt: str,
    n: int = 1,
    temperature: float = 1.0,
    model_id: str = "gpt-4o",
    system_prompt = None,
    retry_count: int = 1e9,
    max_tokens: int = 1000,
) -> List[str]:
    client = openai.OpenAI()

    backoff = 1
    retry_count = int(retry_count)
    if system_prompt:
        messages = [ {"role": "system", "content": system_prompt}, {"role": "user", "content": prompt}]
    else:
        messages = [ {"role": "user", "content": prompt}]
    for attempt in range(retry_count):
        try: 
            response = client.chat.completions.create(
                model=model_id,
                messages=messages,
                temperature=temperature,
                n=n,
                max_tokens=max_tokens,
            )
            break
        except Exception as e:
            if "429" in str(e):
                print("Retry due to rate limit: ", e)
                time.sleep(backoff)
                backoff = min(backoff * 2, 64)  # Exponential backoff up to 64s
                continue
            else:
                print("Exception: ", e)
                return []

    if n == 1:
        return response.choices[0].message.content
    return [choice.message.content for choice in response.choices]
def write_result(result, output_file):
    if result is None:
        return
        
    with open(output_file, 'a') as f:
        fcntl.flock(f.fileno(), fcntl.LOCK_EX)
        try:
            f.write(json.dumps(result) + '\n')
        finally:
            fcntl.flock(f.fileno(), fcntl.LOCK_UN)
            
            
SYSTEM_SUPERFORECASTER_0 = """You are an expert superforecaster, familiar with the work of Tetlock and others.
Your mission is to generate accurate predictions for forecasting questions.
Aggregate the information provided by the user. Make sure to give detailed reasonings."""