import pandas as pd
import openai
import time
from typing import List
import os


from utils import write_result, filter_seen_solutions, call_anth_rm_llm
# get t from command line
import sys
T = float(sys.argv[1])

# Load prompts from CSV file
df = pd.read_csv("prompts.csv")

# Get prompts
prompts = df['prompt'].tolist()
        
max_length = 100



# in parallel make calls and write to jsonl file

import json
import threading
import fcntl
from concurrent.futures import ThreadPoolExecutor
import pandas as pd
import anthropic

def process_prompt(prompt, i):

    outputs = call_anth_rm_llm(prompt, n=100, temperature=T, model_id="claude-3-7-sonnet-20250219")
    
    if not outputs:
        return None
        
    result = {
        "idx": i,
        "prompt": prompt,
        "completions": outputs
    }
    return result


def process_and_write(prompt, output_file, i):
    result = process_prompt(prompt, i)
    if result:
        write_result(result, output_file)
    print(f"Processed {i} of {len(prompts)} prompts")

# Read prompts from CSV
prompts_df = pd.read_csv('prompts.csv')
prompts = prompts_df['prompt'].tolist()

output_file = f'final_data/baseline_completions_temp_{str(T)}_anth.jsonl'

if os.path.exists(output_file):
    raise Exception("Output file already exists")
# Create/clear the output file
open(output_file, 'w').close()


# Process prompts in parallel
with ThreadPoolExecutor(max_workers=100) as executor:
    futures = [
        executor.submit(process_and_write, prompt, output_file, i)
        for i, prompt in enumerate(prompts)
    ]
    
    # Wait for all futures to complete
    for future in futures:
        future.result()




    
    
