# download from HF llm-aes/writing-prompts

import os
import requests
import pandas as pd
import random
from datasets import load_dataset

def download_file(url, filename):
    response = requests.get(url)
    with open(filename, 'wb') as file:
        file.write(response.content)

# Load the dataset from Hugging Face
dataset = load_dataset("llm-aes/writing-prompts")

# Get all prompts from the dataset
prompts = dataset['train']['prompt']

# Randomly sample 100 prompts
sampled_prompts = random.sample(prompts, 100)

# Save to file as pandas dataframe
df = pd.DataFrame(sampled_prompts, columns=['prompt'])
df.to_csv("prompts.csv", index=False)


