import pandas as pd
import openai
import time
from typing import List


import json
import threading
import fcntl
from concurrent.futures import ThreadPoolExecutor
import pandas as pd

from utils import call_oai_rm_llm
# Load prompts from CSV file
df = pd.read_csv("prompts.csv")

# Get prompts
prompts = df['prompt'].tolist()

# Save prompts to file
with open("prompts.txt", "w") as file:
    for prompt in prompts:
        file.write(prompt + "\n")
        
max_length = 1000
        
prompt_format = """Imagine all the 3 act stories that can be written based on this prompt: 

{prompt}

Propose 5 questions with two options that might evenly split 100 stories written by participants. Some examples of questions are Type of Ending(happy, sad, twist, etc), Supernatural vs Historical fiction, main character's flaw, or common tropes.

Format: 

BRAINSTORMING:
A. List of questions other than the suggested onesthat might be relevant and split 100 stories evenly
B. For each question, propose two options that might split 100 stories evenly

FINAL ANSWER:

1. **<Name of Choice>**
- The story ... <Option 1>
- The story ... <Option 2>

"""

def parse_result(result):
    # result is in the format of 1. <Name of Choice> - The story ... <Option 1> - The story ... <Option 2>
    # 2. <Name of Choice> - The story ... <Option 1> - The story ... <Option 2>
    # ...
    # 5. <Name of Choice> - The story ... <Option 1> - The story ... <Option 2>
    
    options = [] # name of choice, option 1, option 2
    
    # ignore everything until "FINAL ANSWER:"
    result = result.split("FINAL ANSWER:")
    if len(result) < 2:
        return []
    result = result[1]
    
    # split by line
    lines = result.split('\n')
    current_option = {}
    for line in lines:
        if len(line) < 2:
            continue
        if line[0].isdigit() and line[1] == '.':
            # we're in a new option
            if current_option:
                options.append(current_option)
            current_option = {}
            current_option['name'] = line[2:].strip().replace('**', '')
            current_option['options'] = []
            
        if line.strip().startswith('-'):
            current_option['options'].append(line.strip().replace('-', '').strip())
    else: 
        if current_option:
            options.append(current_option)
    return options

# in parallel make calls and write to jsonl file


def process_prompt(prompt, max_attempts=5):
    prompt_formatted = prompt_format.format(prompt=prompt)
    for i in range(max_attempts):
        outputs = call_oai_rm_llm(prompt_formatted, n=1, temperature=0.5, model_id="gpt-4o")
        
        if not outputs:
            return None
        
        parsed_result = parse_result(outputs)
        
        if len(parsed_result) <= 3:
            continue
        else:
            
            result = {
                "prompt": prompt,
                "raw_result": outputs,
                "options": parse_result(outputs)
            }
            break
    
    
    return result

def write_result(result, output_file):
    if result is None:
        return
        
    with open(output_file, 'a') as f:
        fcntl.flock(f.fileno(), fcntl.LOCK_EX)
        try:
            f.write(json.dumps(result) + '\n')
        finally:
            fcntl.flock(f.fileno(), fcntl.LOCK_UN)

def process_and_write(prompt, output_file, i):
    result = process_prompt(prompt)
    if result:
        write_result(result, output_file)
    print(f"Processed {i} of {len(prompts)} prompts")

# Read prompts from CSV
prompts_df = pd.read_csv('prompts.csv')
prompts = prompts_df['prompt'].tolist()

output_file = 'modified_prompts.jsonl'

# Create/clear the output file
open(output_file, 'w').close()
# Process prompts in parallel
with ThreadPoolExecutor(max_workers=50) as executor:
    futures = [
        executor.submit(process_and_write, prompt, output_file, i)
        for i, prompt in enumerate(prompts)
    ]
    
    # Wait for all futures to complete
    for future in futures:
        future.result()




    
    
