import matplotlib.pyplot as plt
import seaborn as sns
import pandas as pd

# Data for the metrics, correlations, and p-values
data = {
    'Metric': [
        'Token Count (R)', 'Toxicity (P)', 'Toxicity (R)', 'TTR (P)',
        'Semantic Similarity', 'Sentiment (R)', 'Euclidean Distance', 'Token Count (P)',
        'Readability (P)', 'Readability (R)', 'KL Divergence', 'Sentiment (P)', 'TTR (R)'
    ],
    'Correlation': [
        0.7141, 0.7077, 0.7014, 0.6130, 0.0379, -0.0379, -0.0379, -0.2464,
        -0.3033, -0.4013, -0.4139, -0.6635, -0.7141
    ],
    'P-value': [
        0.000873, 0.001016, 0.001179, 0.006835, 0.881266, 0.881266, 0.881266, 0.324209,
        0.221111, 0.098854, 0.087719, 0.002681, 0.000873
    ]
}

# Convert the data into a pandas DataFrame
df = pd.DataFrame(data)

# Create the plot with a smaller figure size
plt.figure(figsize=(6, 4))
ax = sns.barplot(x='Correlation', y='Metric', data=df, palette='Blues')

# Add asterisks for significant p-values (p-value < 0.05)
for i, pval in enumerate(df['P-value']):
    if pval < 0.05:
        if(df['Correlation'][i] > 0):
            ax.text(df['Correlation'][i] + 0.04, i, '*', color='black', ha='center', va='center', fontsize=16)
        else:
            ax.text(df['Correlation'][i] - 0.04, i, '*', color='black', ha='center', va='center', fontsize=16)

# Shrink font sizes for labels and title
plt.title('Metric-ASR Correlation', fontsize=18)
plt.xlabel('Correlation', fontsize=16)
plt.ylabel('Metric', fontsize=16)

# Adjust layout for compactness
plt.tight_layout(pad=1.0)

plt.savefig("smallplot.pdf", bbox_inches='tight')
# Show plot
plt.show()
