import matplotlib.pyplot as plt
import seaborn as sns
import pandas as pd
import numpy as np

sns.set_theme(style="whitegrid", font_scale=1.5)

datasets = ["Benign", "Engineering", "Legal", "Cybersecurity", "LAT-Harmful", "CB-Harmful"]

metric_data = {
    "Question TTR": [0.958, 0.923, 0.856, 0.921, 0.969, 0.966],
    "Response TTR": [0.848, 0.841, 0.882, 0.757, 0.670, 0.636],
    "Question Toxicity": [1.60e-3, 8.00e-4, 7.00e-4, 6.20e-3, 2.92e-2, 3.28e-2],
    "Response Toxicity": [4.40e-3, 7.00e-4, 8.00e-4, 9.00e-4, 1.62e-2, 2.03e-2],
    "Question Sentiment": [0.060, 0.0097, 0.0218, 0.0376, -0.0583, -0.0147],
    "Response Length": [56.4, 65.1, 45.5, 105, 123, 374]
}

colors = ["#636EFA", "#EF553B", "#00CC96", "#AB63FA", "#FFA15A", "#19D3F3"]

fig, axes = plt.subplots(2, 3, figsize=(14, 12), constrained_layout=True)
metrics = list(metric_data.keys())
for ax, metric in zip(axes.flat, metrics):
    sns.lineplot(x=datasets, y=metric_data[metric], marker='o', linewidth=2.5, markersize=10, color=colors[metrics.index(metric)], ax=ax)
    ax.set_title(metric, fontsize=30, weight="bold", pad=20)
    ax.tick_params(axis='x', rotation=60, labelsize=22)
    ax.tick_params(axis='y', labelsize=18)
    ax.grid(True, which="major", linestyle="--", alpha=0.6)

#plt.savefig("EMNLP_Metric_Plots_Polished_Vertical.pdf", dpi=300)
plt.show()
