
<h2 align="center"> <a href="...">MVGS: Multi-View Regulated Gaussian Splatting for Novel View Synthesis</a></h2>
<h5 align="center"> If you like our project, please give us a star ⭐ on GitHub for latest update.  </h2>

<h5 align="center">

### <p align="center">[🌐Project Page](...) | [🖨️ArXiv](...) | [📰Paper](...)</p>


<img src="assets/teaser.png"/>



## 😮 Highlights
MVGS can be easily embeded into existing Gaussian-based explict representation methods for better novel view synthesis results.
 We transform a traditional training paradigm only constrained by a single-view supervision per training iteration with our proposed multi-view training.
### 🔥 Four key Contributions 
- Multi-view constraint loss:
We first propose to supplement multi-view constraints during optimization towards the 3D Gaussian attributes. As a general solution, we improve the overall accuracy in a variety of scenarios and different Gaussian-based methods.
- Cross-intrinsic Guidance method: training in a coarse-to-fine manner with regard to different resolutions.
- Cross-ray Densification: densifying more 3D Gaussians in ray-intersect regions. 
- Multi-view Augmented Densification Strategy:  to enhance the effect of densification while each view is distinct dramatically. 

## 🚩 **Updates**

Welcome to **watch** 👀 this repository for the latest updates.

✅ **[2024.10.1]** : Release [project page](...).

✅ **[2024.10.1]** : Code Release. 





## Installation

1. Clone this repo:

```
git clone ... --recursive
cd MVGS
```

2. Install dependencies (Skip, if you've installed environment for 3DGS.)
```
conda env create --file environment.yml
conda activate mvgs
```

## Quickstart
```
python run_360.py
```
If you GPU memory is limited, try decrease mv value like below code:
```
python train.py -s  {data_path}   --eval --white_background  -m {model_name}  --mv  6  
```






## ✏️ Citation

If you find our paper and code useful in your research, please consider giving a star :star: and citation :pencil:.


```BibTeX

