[![Python](https://img.shields.io/badge/python-3-blue.svg)](https://www.python.org/downloads/)

# MAN TruckScenes devkit

## Overview
- [Devkit setup](#devkit-setup)
- [TruckScenes](#TruckScenes)
  - [Setup](#TruckScenes-setup)
  - [Getting started](#getting-started-with-TruckScenes)
- [Known issues](#known-issues)
- [Citation](#citation)

## Devkit setup
Prerequisites:
- Python (install [here](https://www.python.org/downloads/), tested for 3.6 and 3.8)
- Pip (install [here](https://pip.pypa.io/en/stable/installation/))

Our devkit is installed via pip:
```
pip install -e <path to devkit>
```

## TruckScenes
MAN TruckScenes is the first multimodal dataset for autonomous trucking.  
Downloading and working with the dataset is explained below.

### TruckScenes setup
To download MAN TruckScenes you need to go to the [Download page](https://registry.opendata.aws/) and search for TruckScenes.  

For the devkit to work you will need to download **all** archives.
Please unpack the archives to the `/data/manscenes` folder **without** overwriting folders that occur in multiple archives.
Eventually you should have the following folder structure:
```
/data/manscenes
    samples	-	Sensor data for keyframes.
    sweeps	-	Sensor data for intermediate frames.
    v1.0-*	-	JSON tables that include all the meta data and annotations. Each split (trainval, test, mini) is provided in a separate folder.
```
If you want to use another folder, specify the `dataroot` parameter of the MANScenes class (see tutorial).

### Getting started with TruckScenes
Please follow these steps to make yourself familiar with the MAN TruckScenes dataset:
- [Download](https://registry.opendata.aws/) the dataset on our website.
- Make yourself familiar with the [dataset schema](./docs/schema_manscenes.md)
- Run the [tutorial](./python-sdk/tutorials/manscenes_tutorial.ipynb) to get started:
  ```
  jupyter notebook $HOME/man-devkit/python-sdk/tutorials/manscenes_tutorial.ipynb
  ```
- Read the MAN TruckScenes paper for a detailed analysis of the dataset.





_Copied and adapted from [nuscenes-devkit](https://github.com/nutonomy/nuscenes-devkit)_
