#!/usr/bin/env bash

if [ ${BASH_VERSINFO[0]} -le 4 ]; then
  echo 'This script requires bash version >=4 to run.'
  exit 1
fi
set -e
cd repo

function process_output {
  mkdir -p $(dirname $2)
  cat $1 |\
    grep 'train$' |\
    awk -F, '{print "["$1"]"}' |\
    tr ' ' , \
    >$2
}

declare -A game_names
game_names[ref]=reference
game_names[setref]=set_reference
game_names[concept]=concept

# Shapeworld
(cd data/ && download_shapeworld.sh)
# "run0" is just any name to keep track of the experiment
exp_name=run0
./run_sw.sh run0

for game in ref setref concept; do
  out_fn=../../data/shapeworld-${game_names[$game]}/corpus.jsonl
  in_fn=exp/sw_${game}_20_ex_$exp_name/sampled_lang.csv
  process_output $in_fn $out_fn
done


# CUB (birds)
mkdir -p data/cub
cd data/
  cd cub/
    wget -O CUB_200_2011.tgz https://data.caltech.edu/records/65de6-vp158/files/CUB_200_2011.tgz?download=1
    tar xf CUB_200_2011.tgz
  cd ..
  python save_cub_np.py
cd ..
exp_name=run1
./run_cub.sh $exp_name

for game in ref setref concept; do
  out_fn=../../data/cub-${game_names[$game]}/corpus.jsonl
  in_fn=exp/cub_${game}_10_ex_$exp_name/sampled_lang.csv
  process_output $in_fn $out_fn
done
