# The script takes the place of repo/srcipts/train.sh
import sys
import runpy
import os

new_paths = [os.path.realpath(p) for p in [".", "./src", "./gym_ww"]]
sys.path = new_paths + sys.path

# os.environ["PYTHONPATH"] = "./src:./gym_ww:" + os.environ.get("PYTHONPATH", 
if "PYTHONPATH" in os.environ:
    os.environ["PYTHONPATH"] = ":" + os.environ["PYTHONPATH"]
else:
    os.environ["PYTHONPATH"] = ""
os.environ["PYTHONPATH"] = "./src:./gym_ww:" + os.environ["PYTHONPATH"]



from utils import Params


cfgs = {
    # num_player, signal_length, signal_range]
    "9-player": [9, 9, 9],
    "9-player-nc": [9, 0, 9],
    "21-player": [21, 21, 21],
    "21-player-nc": [21, 0, 21],
}
cfg_name = sys.argv[1]
cfg = cfgs[cfg_name]

# Monkey patch the parameter in
Params.num_player = cfg[0]
Params.signal_length = cfg[1]
Params.signal_range = cfg[2]

if len(sys.argv) > 2:
    Params.checkpoint_path = sys.argv[2]
    Params.corpus_generation = True

runpy._run_module_as_main("src.trainable.train_appo")
