"use client";

import { AgGridReact } from 'ag-grid-react';
import { RowClickedEvent } from 'ag-grid-community';
import "ag-grid-community/styles/ag-grid.css";
import "ag-grid-community/styles/ag-theme-quartz.css";

type TableRow = {
  // name: string,
  // values: {[key: string]: string | number | boolean},
  name: string,
  variant: string,
  [key: string]: string | number | boolean,
};

type Table = {
  headers: Array<string>;
  rows: Array<TableRow>;
};

type Props = {
  tableData: Array<TableRow>;
};

const rowClickHandler = (e: RowClickedEvent) => {
  window.open(`${window.origin}/language/${e.data.name}`, "_blank");
};


export default function LangTable({tableData}: Props) {
  const defaults = { suppressMovable: true };
  const colDefs = [
    { ...defaults, field: "name", flex: 2, pinned: 'left' } as const,
    { ...defaults, field: "variant", flex: 2, pinned: 'left' } as const,
    { ...defaults, field: "game-type" },
    { ...defaults, field: "game-subtype" },
    { ...defaults, field: "data-source" },
    { ...defaults, field: "entropy_1gram", valueGetter: (p: any) => p.data.entropy_1gram.toFixed(2), type: "numericColumn" },
  ];

  return (
      <AgGridReact
        className="ag-theme-quartz"
        rowData={tableData}
        onRowClicked={rowClickHandler}
        columnDefs={colDefs}
      />
  );
}
