#!/usr/bin/env bash

# Change to 1 to debug
n_jobs=$(nproc)

set -xe

mkdir -p ../data/

cd repo
  for c in nav_elcc_temperature nav_elcc_lexicon_size; do
    python -m simple_nav run $c -j$n_jobs
    python -m simple_nav eval log/$c -j$n_jobs
    for x in results/$c/*.jsonl; do
      name=$(basename $x .messages.jsonl)
      mkdir ../../data/$name
      cp $x ../../data/$name/corpus.jsonl
    done
  done
cd ..


