Welcome to the repository dedicated to the study of cooperation and emergent communication in social deduction games, specifically, the Werewolf game.

## Publication 

Our work, "RLupus: Cooperation through emergent communication in The Werewolf social deduction game," has been published! For an in-depth understanding of the problem statement, our proposed solutions, and experimental results, check out the paper on [arXiv](https://arxiv.org/abs/2106.05018). 

You can also watch our [video presentation](https://youtu.be/i8lyvepGODw) on YouTube for an overview of our research.

Cite our paper using the following citation:
```
@article{brandizzi2021rlupus,
  author    = {Brandizzi, Nicolo' and
               Grossi, Davide and
               Iocchi, Luca},
  title     = {RLupus: Cooperation through emergent communication in The Werewolf
               social deduction game},
  journal={Intelligenza Artificiale},
  volume={15},
  number={2},
  pages={55--70},
  year={2021},
  publisher={IOS Press}
}
```

## Werewolf Game: A Study in Emergent Communication

Werewolf is a simple yet fascinating social deduction game, known across the globe by different names. In this game, the cooperation and cunning of players, divided into villagers and werewolves, shape the outcome.

The game unfolds in two phases: night and day. During the night, all players close their eyes, and werewolves choose their victims. During the day, everyone assesses the events of the previous night and decides who to execute. The game continues until there are no more werewolves or the werewolves outnumber the villagers.

The essence of our study lies in understanding the importance of communication signals in affecting the winning chances of players and studying the effect of signal's length and range on overall performance.

## Getting Started with the Repository

### Installation
Start by installing the necessary components. For step-by-step instructions, refer to our detailed [Installation Guide](Resources/MarkDowns/Installation.md).

### Understanding the Architecture
The repository contains a wealth of information explaining different aspects of the implementation:

- For an in-depth understanding of the entire architecture, see the [Specification Document](Resources/MarkDowns/Specs.md).
- To track the development process and issues encountered, refer to our [Journal](Resources/MarkDowns/Journal.md).
- For details about each environment and their differences, check out the [Environment Directory](gym_ww/envs) and the associated [README](gym_ww/envs/README.md).
- The findings and methodologies of this project are documented in the [Thesis](Resources/thesis.pdf).

We hope our research sparks your interest and helps you in your study of social deduction games. Enjoy exploring the repository!
