import type { Metadata } from "next";
import { Inter } from "next/font/google";
import "./globals.css";

const inter = Inter({ subsets: ["latin"] });

export const metadata: Metadata = {
  title: "Emergent Language Library",
  description: "Generated by create next app",
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="en">
      <body className={inter.className + " h-screen flex-col flex"}>
        <header
          style={{ fontVariant: undefined }}
          className="bg-slate-100 py-3 px-4 h-16"
        >
          <a
            href="/"
            className="border-2 border-black border-solid box-border inline-block align-middle rounded-md p-1 font-sans text-xl hover:underline hover:cursor-pointer"
          > 
          Emergent Language Library
          </a>
        </header>
        <main className="p-8 min-h-0 flex-auto flex flex-col">
          {children}
        </main>
      </body>
    </html>
  );
}
