import numpy as np

def generate_banana_data(n_points, noise_lambda, x_range=2, centered=True):
    # Generate linear data
    x = np.linspace(-x_range, x_range, n_points)
    y = x**2
    
    # Add Gaussian noise
    data = np.zeros((n_points,2))
    data[:,0] = x + np.random.normal(0, noise_lambda, n_points)
    data[:,1] = y + np.random.normal(0, noise_lambda, n_points)

    #mean center data explicitly
    if centered:
        data = data - np.mean(data, axis=0)
    
    return data