#!/usr/bin/env python3
# -*- coding: utf-8 -*-


class baseAnomalyDetector:
    def __init__(self, parameter1=defaultValue1, parameter2=defaultValue2):
        """
        Initialize parameters.

        Parameters:
        parameter1 : type, default=defaultValue1
            Description of parameter1.
        parameter2 : type, default=defaultValue2
            Description of parameter2.
        """
        self.parameter1 = parameter1
        self.parameter2 = parameter2

    def fit(self, X):
        """
        Fit the model to the training data.

        Parameters:
        X : {array-like, sparse matrix}, shape (n_samples, n_features)
            Training data.
        Returns:
        self : object
            Returns self.
        """
        # Model fitting logic goes here
        return self

    def predict(self, X):
        """
        Predict class labels for samples in X.

        Parameters:
        X : {array-like, sparse matrix}, shape (n_samples, n_features)
            Samples.

        Returns:
        y_pred : array, shape (n_samples,)
            Class labels.
        """
        # Prediction logic goes here
        return y_pred

    def fit_predict(self, X):
        """
        Fit the model to the training data and then predict on the same data.

        Parameters:
        X : {array-like, sparse matrix}, shape (n_samples, n_features)
            Training data.
        y : array-like, shape (n_samples,)
            Target values.

        Returns:
        y_pred : array, shape (n_samples,)
            Class labels predicted on the same data.
        """
        self.fit(X)
        return self.predict(X)
