import matplotlib.pyplot as plt

# Function to visualize a sample
def visualize_sample(sample):
    sample = sample.squeeze()
    plt.imshow(sample, cmap="gray")
    plt.axis('off')

# Function to visualize a sample and its reconstruction
def visualize_reconstruction(sample, reconstructed_sample):
    fig, axes = plt.subplots(1, 2, figsize=(8, 4))

    # Original Sample
    axes[0].imshow(sample.squeeze(), cmap="gray")
    axes[0].set_title("Original Sample")
    axes[0].axis("off")

    # Reconstructed Sample
    axes[1].imshow(reconstructed_sample.squeeze(), cmap="gray")
    axes[1].set_title("Reconstructed Sample")
    axes[1].axis("off")
    plt.axis('off')
