# For keeping track of execution, I comment out the experiments that have run / are running

###
# env
###
#conda activate sc_mechinterp

###
# sweep
###

# unimodal sweep to find good hyperparameters for the method
python 02_paper_experiments/030_unimodal_param_sim_sweep.py --threshold relative --seed 0
python 02_paper_experiments/030_unimodal_param_sim_sweep.py --threshold relative --seed 42
python 02_paper_experiments/030_unimodal_param_sim_sweep.py --threshold relative --seed 9306
python 02_paper_experiments/030_unimodal_param_sim_sweep.py --threshold absolute --seed 0
python 02_paper_experiments/030_unimodal_param_sim_sweep.py --threshold absolute --seed 42
python 02_paper_experiments/030_unimodal_param_sim_sweep.py --threshold absolute --seed 9306

###
# swiss roll demo
###
python 02_paper_experiments/032_swiss_roll.py
python 02_paper_experiments/032_swiss_roll.py --noise 0.1
python 02_paper_experiments/032_scurve.py
python 02_paper_experiments/032_scurve.py --noise 0.1
python 02_paper_experiments/032_hypersphere.py
python 02_paper_experiments/032_hypersphere.py --noise 0.1

###
# robustness experiments
###
#chmod +x 02_paper_experiments/00_02_sub_robustness.sh
02_paper_experiments/00_02_sub_robustness.sh samples 1
02_paper_experiments/00_02_sub_robustness.sh data 1
02_paper_experiments/00_02_sub_robustness.sh noise 1

#python 02_paper_experiments/031_unimodal_param_sim_robustness_to_metric.py

###
# omics single modalities benchmark
###

# non-NN methods
python 02_paper_experiments/030_compute_basic_ID_estimation_metrics.py --modality 'rna' --n_batches 3 --seed 0
python 02_paper_experiments/030_compute_basic_ID_estimation_metrics.py --modality 'rna' --n_batches 3 --seed 42
python 02_paper_experiments/030_compute_basic_ID_estimation_metrics.py --modality 'rna' --n_batches 3 --seed 9306
python 02_paper_experiments/030_compute_basic_ID_estimation_metrics.py --modality 'protein' --n_batches 3 --seed 0
python 02_paper_experiments/030_compute_basic_ID_estimation_metrics.py --modality 'protein' --n_batches 3 --seed 42
python 02_paper_experiments/030_compute_basic_ID_estimation_metrics.py --modality 'protein' --n_batches 3 --seed 9306

# loss cliff
python 02_paper_experiments/03b_compute_IDE_recon_cliff.py --modality 'rna' --n_batches 3 --steps 20 --seed 0 --total_decrease_threshold 0.8
python 02_paper_experiments/03b_compute_IDE_recon_cliff.py --modality 'rna' --n_batches 3 --steps 20 --seed 0 --total_decrease_threshold 0.95
python 02_paper_experiments/03b_compute_IDE_recon_cliff.py --modality 'rna' --n_batches 3 --steps 20 --seed 42 --total_decrease_threshold 0.8
python 02_paper_experiments/03b_compute_IDE_recon_cliff.py --modality 'rna' --n_batches 3 --steps 20 --seed 42 --total_decrease_threshold 0.95
python 02_paper_experiments/03b_compute_IDE_recon_cliff.py --modality 'rna' --n_batches 3 --steps 20 --seed 9306 --total_decrease_threshold 0.8
python 02_paper_experiments/03b_compute_IDE_recon_cliff.py --modality 'rna' --n_batches 3 --steps 20 --seed 9306 --total_decrease_threshold 0.95
python 02_paper_experiments/03b_compute_IDE_recon_cliff.py --modality 'protein' --n_batches 3 --steps 20 --seed 0 --total_decrease_threshold 0.8
python 02_paper_experiments/03b_compute_IDE_recon_cliff.py --modality 'protein' --n_batches 3 --steps 20 --seed 0 --total_decrease_threshold 0.95
python 02_paper_experiments/03b_compute_IDE_recon_cliff.py --modality 'protein' --n_batches 3 --steps 20 --seed 42 --total_decrease_threshold 0.8
python 02_paper_experiments/03b_compute_IDE_recon_cliff.py --modality 'protein' --n_batches 3 --steps 20 --seed 42 --total_decrease_threshold 0.95
python 02_paper_experiments/03b_compute_IDE_recon_cliff.py --modality 'protein' --n_batches 3 --steps 20 --seed 9306 --total_decrease_threshold 0.8
python 02_paper_experiments/03b_compute_IDE_recon_cliff.py --modality 'protein' --n_batches 3 --steps 20 --seed 9306 --total_decrease_threshold 0.95

# reduced-rank AE
python 02_paper_experiments/03c_compute_IDE_reduced_rank_AE.py --n_batches 1 --modality 'rna' --epochs 5000 --seed 0
python 02_paper_experiments/03c_compute_IDE_reduced_rank_AE.py --n_batches 1 --modality 'rna' --epochs 5000 --seed 42
python 02_paper_experiments/03c_compute_IDE_reduced_rank_AE.py --n_batches 1 --modality 'rna' --epochs 5000 --seed 9306
python 02_paper_experiments/03c_compute_IDE_reduced_rank_AE.py --n_batches 1 --modality 'protein' --epochs 5000 --seed 0
python 02_paper_experiments/03c_compute_IDE_reduced_rank_AE.py --n_batches 1 --modality 'protein' --epochs 5000 --seed 42
python 02_paper_experiments/03c_compute_IDE_reduced_rank_AE.py --n_batches 1 --modality 'protein' --epochs 5000 --seed 9306

# ARD-VAE
python 02_paper_experiments/03h_compute_IDE_ARDVAE.py --modality 'rna' --n_batches 3 --seed 0 --lr 1e-4 --kl_weight 1.0
python 02_paper_experiments/03h_compute_IDE_ARDVAE.py --modality 'rna' --n_batches 3 --seed 0 --lr 1e-4 --kl_weight 0.1
python 02_paper_experiments/03h_compute_IDE_ARDVAE.py --modality 'rna' --n_batches 3 --seed 0 --lr 1e-4 --kl_weight 0.01
python 02_paper_experiments/03h_compute_IDE_ARDVAE.py --modality 'rna' --n_batches 3 --seed 0 --lr 1e-4 --kl_weight 0.001
python 02_paper_experiments/03h_compute_IDE_ARDVAE.py --modality 'rna' --n_batches 3 --seed 0 --lr 1e-4 --kl_weight 0.0001
python 02_paper_experiments/03h_compute_IDE_ARDVAE.py --modality 'rna' --n_batches 3 --seed 42 --lr 1e-4 --kl_weight 1.0
python 02_paper_experiments/03h_compute_IDE_ARDVAE.py --modality 'rna' --n_batches 3 --seed 42 --lr 1e-4 --kl_weight 0.1
python 02_paper_experiments/03h_compute_IDE_ARDVAE.py --modality 'rna' --n_batches 3 --seed 42 --lr 1e-4 --kl_weight 0.01
python 02_paper_experiments/03h_compute_IDE_ARDVAE.py --modality 'rna' --n_batches 3 --seed 42 --lr 1e-4 --kl_weight 0.001
python 02_paper_experiments/03h_compute_IDE_ARDVAE.py --modality 'rna' --n_batches 3 --seed 42 --lr 1e-4 --kl_weight 0.0001
python 02_paper_experiments/03h_compute_IDE_ARDVAE.py --modality 'rna' --n_batches 3 --seed 9306 --lr 1e-4 --kl_weight 1.0
python 02_paper_experiments/03h_compute_IDE_ARDVAE.py --modality 'rna' --n_batches 3 --seed 9306 --lr 1e-4 --kl_weight 0.1
python 02_paper_experiments/03h_compute_IDE_ARDVAE.py --modality 'rna' --n_batches 3 --seed 9306 --lr 1e-4 --kl_weight 0.01
python 02_paper_experiments/03h_compute_IDE_ARDVAE.py --modality 'rna' --n_batches 3 --seed 9306 --lr 1e-4 --kl_weight 0.001
python 02_paper_experiments/03h_compute_IDE_ARDVAE.py --modality 'rna' --n_batches 3 --seed 9306 --lr 1e-4 --kl_weight 0.0001
python 02_paper_experiments/03h_compute_IDE_ARDVAE.py --modality 'protein' --n_batches 3 --seed 0 --lr 1e-4 --kl_weight 1.0
python 02_paper_experiments/03h_compute_IDE_ARDVAE.py --modality 'protein' --n_batches 3 --seed 0 --lr 1e-4 --kl_weight 0.1
python 02_paper_experiments/03h_compute_IDE_ARDVAE.py --modality 'protein' --n_batches 3 --seed 0 --lr 1e-4 --kl_weight 0.01
python 02_paper_experiments/03h_compute_IDE_ARDVAE.py --modality 'protein' --n_batches 3 --seed 0 --lr 1e-4 --kl_weight 0.001
python 02_paper_experiments/03h_compute_IDE_ARDVAE.py --modality 'protein' --n_batches 3 --seed 0 --lr 1e-4 --kl_weight 0.0001
python 02_paper_experiments/03h_compute_IDE_ARDVAE.py --modality 'protein' --n_batches 3 --seed 42 --lr 1e-4 --kl_weight 1.0
python 02_paper_experiments/03h_compute_IDE_ARDVAE.py --modality 'protein' --n_batches 3 --seed 42 --lr 1e-4 --kl_weight 0.1
python 02_paper_experiments/03h_compute_IDE_ARDVAE.py --modality 'protein' --n_batches 3 --seed 42 --lr 1e-4 --kl_weight 0.01
python 02_paper_experiments/03h_compute_IDE_ARDVAE.py --modality 'protein' --n_batches 3 --seed 42 --lr 1e-4 --kl_weight 0.001
python 02_paper_experiments/03h_compute_IDE_ARDVAE.py --modality 'protein' --n_batches 3 --seed 42 --lr 1e-4 --kl_weight 0.0001
python 02_paper_experiments/03h_compute_IDE_ARDVAE.py --modality 'protein' --n_batches 3 --seed 9306 --lr 1e-4 --kl_weight 1.0
python 02_paper_experiments/03h_compute_IDE_ARDVAE.py --modality 'protein' --n_batches 3 --seed 9306 --lr 1e-4 --kl_weight 0.1
python 02_paper_experiments/03h_compute_IDE_ARDVAE.py --modality 'protein' --n_batches 3 --seed 9306 --lr 1e-4 --kl_weight 0.01
python 02_paper_experiments/03h_compute_IDE_ARDVAE.py --modality 'protein' --n_batches 3 --seed 9306 --lr 1e-4 --kl_weight 0.001
python 02_paper_experiments/03h_compute_IDE_ARDVAE.py --modality 'protein' --n_batches 3 --seed 9306 --lr 1e-4 --kl_weight 0.0001

# our method
python 02_paper_experiments/033_unimodal_omics.py --modality 'rna' --n_batches 3 --threshold_type 'absolute' --seed 0
python 02_paper_experiments/033_unimodal_omics.py --modality 'rna' --n_batches 3 --threshold_type 'absolute' --seed 42
python 02_paper_experiments/033_unimodal_omics.py --modality 'rna' --n_batches 3 --threshold_type 'absolute' --seed 9306
python 02_paper_experiments/033_unimodal_omics.py --modality 'protein' --n_batches 3 --threshold_type 'absolute' --seed 0
python 02_paper_experiments/033_unimodal_omics.py --modality 'protein' --n_batches 3 --threshold_type 'absolute' --seed 42
python 02_paper_experiments/033_unimodal_omics.py --modality 'protein' --n_batches 3 --threshold_type 'absolute' --seed 9306