# Reviewer Guide: Compression and Intrinsic Dimensionality

This guide is designed to help reviewers navigate the repository, set up the environment, and understand the structure of our experiments.

## Table of Contents

1. [Quick Start](#quick-start)
2. [Repository Structure](#repository-structure)
3. [Running Experiments](#running-experiments)

---

## Quick Start

For reviewers who want to get started immediately:

```bash
# 1. Set up the environment
conda env create -f environment.yml 

# 2. Configure paths (see Configuration section below)
cp .env.example .env
# Edit .env to set custom data paths
```

---

## Repository Structure

The repository is organized into several key directories:

```
compression_intrinsic-dimensionality/
│
├── 01_data/                          # Data storage
│   ├── raw/                          # Raw datasets
│   ├── processed/                    # Preprocessed data
│   └── [dataset-specific folders]    # AudioMNIST, MultiBench, etc.
│
├── 02_paper_experiments/             # Main paper experiments (⭐ START HERE)
│   ├── 00_*.sh                       # Bash scripts for running experiments
│   ├── 01_*.py                       # Data generation scripts
│   ├── 02_*.py                       # Hyperparameter sweeps
│   ├── 03*.py                        # Unimodal experiments
│   ├── 04*.py                        # Multimodal experiments
│   ├── 05*.py                        # Real-world data experiments
│   └── analysis/                     # Post-training analysis scripts
│
├── 03_results/                       # Experiment outputs
│
├── src/                              # Source code
│   ├── data/                         # Data loaders and simulators
│   ├── models/                       # Model architectures
│   └── functions/                    # Training and evaluation functions
│
├── config.py                         # Central configuration file
├── environment.yml                   # Conda environment specification
```

---

## Running Experiments

All experiments from the paper can be reproduced using the bash scripts in `02_paper_experiments/`. These scripts contain the exact Python commands used to generate the results.

### Experiment Execution Scripts

The experiments are organized into numbered bash scripts that correspond to different sections of the paper:

#### 📋 **00_01_exec_prep.sh** - Data Preparation & Hyperparameter Tuning
- Generates simulated multimodal data
- Runs hyperparameter optimization sweeps
- **Run first** before other experiments

```bash
bash 02_paper_experiments/00_01_exec_prep.sh
```

#### 📊 **00_02_exec_unimodal.sh** - Unimodal Experiments
- Parametric sweep on synthetic data
- Swiss roll, S-curve, hypersphere demonstrations
- Robustness experiments (samples, data, noise)
- Comparisons with baseline methods (PCA, loss cliff, ARD-VAE, etc.)

```bash
bash 02_paper_experiments/00_02_exec_unimodal.sh
```

**Sub-script for robustness:**
- `00_02_sub_robustness.sh` - Robustness to sample size, data dimension, and noise

#### 🔗 **00_03_exec_multimodal.sh** - Multimodal Experiments (Main)
- Parametric simulations with various data configurations
- Multi-omics experiments (RNA-protein)

```bash
bash 02_paper_experiments/00_03_exec_multimodal.sh
```

**Related multimodal scripts:**
- `00_03_exec_multimodal_ablation.sh` - Ablation studies
- `00_03_exec_multimodal_baselines.sh` - Baseline method comparisons (CCA, JIVE, AJIVE, etc.)
- `00_03_exec_multimodal_additional_losses.sh` - Alternative loss functions
- `00_03_exec_multimodal_edgecases.sh` - Edge case scenarios

#### 🧬 **00_04_exec_realdata.sh** - Real-World Bio/Medical Data Experiments
- NInFEA (neuroimaging + behavioral data)
- scOmics human bone marrow dataset

```bash
bash 02_paper_experiments/00_04_exec_realdata.sh
```

#### 🔊 **00_05_exec_audiomnist.sh** - AudioMNIST Experiments
- Audio-visual multimodal learning
- Digit recognition with audio and visual modalities

```bash
bash 02_paper_experiments/00_05_exec_audiomnist.sh
```

#### 🎬 **00_06_exec_multibench.sh** - MultiBench Experiments
- MM-IMDb (movie genre prediction)

```bash
bash 02_paper_experiments/00_06_exec_multibench.sh
```

**Happy reviewing! 🎉**
