"""
Configuration file for project-specific paths and settings.
This file centralizes user-specific and environment-specific configuration.
"""

import os
from pathlib import Path

# Get the project root directory (where this config.py file is located)
PROJECT_ROOT = Path(__file__).parent.absolute()

# User-specific paths
# Update these paths for your local environment
USER_HOME = Path.home()
USERNAME = os.environ.get('USER', 'user')

# WandB configuration
WANDB_ENTITY = os.environ.get('WANDB_ENTITY', 'your-wandb-entity')  # Set via environment variable or update default
WANDB_PROJECT_DEFAULT = 'compression-intrinsic-dimensionality'

# Data paths
DATA_DIR = PROJECT_ROOT / '01_data'
RESULTS_DIR = PROJECT_ROOT / '03_results'

# External data paths (can be overridden by environment variables)
EXTERNAL_DATA_PATH = os.environ.get('EXTERNAL_DATA_PATH', str(USER_HOME / 'data'))

# Specific dataset paths
SCOMICS_DATA_PATH = os.environ.get('SCOMICS_DATA_PATH', 
                                    str(Path(EXTERNAL_DATA_PATH) / 'human_bonemarrow.h5ad'))

# MultiBench data paths
MULTIBENCH_MOSI_PATH = os.environ.get('MULTIBENCH_MOSI_PATH',
                                       str(DATA_DIR / 'multibench' / 'mosi' / 'mosi.hdf5'))

def get_project_root():
    """Return the project root directory as a string."""
    return str(PROJECT_ROOT)

def get_data_dir():
    """Return the data directory as a string."""
    return str(DATA_DIR)

def get_results_dir():
    """Return the results directory as a string."""
    return str(RESULTS_DIR)
