import wandb

def setup_wandb(run_name, hyperparams, project_name, entity):
    try:
        wandb.init(project=project_name, entity=entity, config=hyperparams)
        wandb.run.name = run_name
    except:
        raise ValueError("Could not initialize wandb. Please check your settings.")

def log_wandb(history, mode="train"):
    if mode == "eval":
        wandb.run.summary.update(history)
    else:
        wandb.log(history)