# Time Series Classification and Explanation Pipeline

This project provides a complete pipeline for training deep learning models on time series datasets and generating explanations using the Multi-view Interactive Explanation (MIX) framework.

# Download dataset
Find name and download in timeseriesclassification.com
Then save as following structure:

```
datasets/
  ├── ArrowHead/
  │     ├── train.npy
  │     ├── test.npy
  │     └── (other preprocessed files)
  ├── Wafer/
  │     ├── train.npy
  │     ├── test.npy
  │     └── ...
  ├── CinCECGTorso/
  │     └── ...
  └── ... (add new dataset folders as needed)
```

Then run
```bash
python preprocess.py
python mean_std_cal.py
```
# Training DL
Example
```bash
bash ./scripts/ArrowHead/resnet34.sh 
```

# MIX explanation
Example
```bash
bash ./MIX_script/ArrowHead/dwt_explain.sh
```

