import ast
import pandas as pd
import os
import json

def jaccard_similarity(set1, set2):
    """
    Calculate the Jaccard similarity between two sets.

    Jaccard similarity = |Intersection(set1, set2)| / |Union(set1, set2)|
    
    :param set1: First set
    :param set2: Second set
    :return: Jaccard similarity as a float
    """
    # Compute the intersection and union of the sets
    intersection = len(set1 & set2)
    union = len(set1 | set2)
    
    # Return the Jaccard similarity
    return intersection / union if union != 0 else 0.0

data_dict = {'ArrowHead': [22, 10, 5], 'BME': [18, 8, 4], 'ECG200':[20, 16, 8], 'CBF':[93, 12, 3], 'Strawberry': [99, 8, 4], 'MixedShapesRegularTrain': [293, 8, 4], 'Yoga': [330, 8, 4], 'FordA':[493, 10, 5], 'GunPointMaleVersusFemale': [46, 8, 4], 'FordB':[446, 12, 6], 'TwoPatterns': [500, 8, 4], 'CinCECGTorso': [142, 24, 12], 'Wafer': [717, 12, 6], 'MixedShapesSmallTrain':[253, 24, 12], 'SemgHandGenderCh2': [90, 10, 5]}
data_name = 'Wafer'
# root_result_dir = 'ICML_results'
# noise_root_result_dir = 'Noise_ICML_results'
model_types = ['resnet', 'bilstm', 'transformer']
# model_types = ['resnet']
wave_level_dict = {}
nume_labels = 3
result_dict_8 = {}
result_dict_20 = {}
result_dict_30 = {}
window_size, step_size = data_dict[data_name][1], data_dict[data_name][2]
for architecture in model_types:
    total_faithfulness_8 = 0
    total_faithfulness_20 = 0
    total_faithfulness_30 = 0
    total_samples = 0
    delete_json_file_path = os.path.join('visual_nomerge_result_neurips_2025_v6', data_name, architecture, 'results', str(data_dict[data_name][0]) +'_'+str(window_size)+'_'+str(step_size)+'_delete_faithfulness.json')
    with open(delete_json_file_path, "r") as json_file:
        result = json.load(json_file)
    result = {int(key): value for key, value in result.items()}
    max_key = max(result, key=lambda k: result[k]['8'] + result[k]['20'] + result[k]['30'])
    result_dict_8[architecture] = result[max_key]['8']
    result_dict_20[architecture] = result[max_key]['20']
    result_dict_30[architecture] = result[max_key]['30']
    wave_level_dict[architecture] = max_key

print(data_dict[data_name], wave_level_dict)
print('f@8', result_dict_8, sum(result_dict_8.values()) / len(result_dict_8))
print('f@20', result_dict_20, sum(result_dict_20.values()) / len(result_dict_20))
print('f@30', result_dict_30, sum(result_dict_30.values()) / len(result_dict_30))

# robustness
robustness_dict = {}
for architecture in model_types:
    exp_json_file_path = os.path.join('visual_nomerge_result_neurips_2025_v6', data_name, architecture, str(data_dict[data_name][0])+'_'+str(window_size)+'_'+str(step_size)+'_Xplanation.json')
    with open(exp_json_file_path, "r") as json_file:
        positions = json.load(json_file)
    positions = {int(key): value for key, value in positions.items()}
    positions = positions[wave_level_dict[architecture]]
    noisy_exp_json_file_path = os.path.join('noise_nomerge_result_neurips_2025_v6', data_name, architecture, str(data_dict[data_name][0])+'_'+str(window_size)+'_'+str(step_size)+'_Xplanation.json')
    with open(noisy_exp_json_file_path, "r") as json_file:
        noisy_positions = json.load(json_file)
    noisy_positions = {int(key): value for key, value in noisy_positions.items()}
    noisy_positions = noisy_positions[wave_level_dict[architecture]]
    robustness = []
    for index in range(len(positions)):
        robustness.append(jaccard_similarity(set(positions[index]), set(noisy_positions[index])))
    robustness_dict[architecture] = sum(robustness)/len(robustness)
print('robustness::', robustness_dict)
            


