```python
import nltk
nltk.download('punkt')
```
```bash
pip install faiss-gpu
```


```
**Objective:**
Classify the provided list of candidate chemical substances into THREE groups according to the [Specified_physicochemical_Properties]. Your primary method for classification must be the utilization of quantitative data that would typically be found in a comprehensive physicochemical property database.

**Crucial Instructions:**
**Prioritize Quantitative Data: **For each substance and property, you should first attempt to classify it based on specific, measurable, quantitative values (e.g. pKa for basicity/acidity, dielectric constant for polarity, boiling point for volatility, specific functional group counts).
**Minimize General Knowledge/Intuition:** Avoid relying on your general, unquantified chemical knowledge or intuition. If a quantitative value from the "database" directly supports a classification, state that. If a direct value isn't typically used for a category but strong structural indicators (which could be quantified, e.g., number of H-bond donors) point to it, explain this as an inference based on data-like principles.
**Adhere to Provided Categories:** Classify substances strictly into the categories provided for each property. If a substance doesn't clearly fit or straddles categories based on (assumed) data, note this ambiguity.

**Candidate Substances to Classify:**
"base": ["KOH","nothing","Et3N","K3PO4","LiOtBu","CsF","NaOH","NaHCO3"]
```


# Loss

buchwald : 
- "ethyl 3-methoxy-1,2-oxazole-5-carboxylate" - Additive
- 'N-[dimethylamino-ethylimino-[[tris(dimethylamino)-lambda5-phosphanylidene]amino]-lambda5-phosphanyl]-N-methylmethanamine' - base