import json

json_file = "/mnt/shared-storage-user/caipengxiang/workspace/ChemBOMAS/train_regression/data4regression/arylation/names_maps.json"
sum_file = "summary.json"

with open(json_file, "r") as f:
    smiles2name = json.load(f)
with open(sum_file, "r") as f:
    sum_data = json.load(f)
name2smiles = {v: k for k, v in smiles2name.items()}

smiles_summary = {}
for key, item in sum_data.items():
    temp_item = []
    for group in item:
        temp_group = []
        for name in group:
            temp_group.append(name2smiles[name])
        temp_item.append(temp_group)
    smiles_summary[key] = temp_item

with open("smiles_summary.json", "w") as f:
    json.dump(smiles_summary, f, indent=4)