Below is one quantitative‐data–based classification, using measured (or literature‐estimated) basicity as judged by the pKa of the conjugate acid (a common numeric descriptor in comprehensive physicochemical databases):

• Group 1 (“Moderate” basicity):  
 – 1‑methyl‑2,3,4,6,7,8‑hexahydropyrimido[1,2‑a]pyrimidine  
  • Data from databases typically list the conjugate acid pKa in aprotic solvents (e.g. acetonitrile) for bicyclic amidines in the range of ~11–12. This moderate basicity (by quantitative pKa numbers) sets it apart from the other two candidates.

• Group 2 (“Strong” basicity):  
 – 2‑tert‑butyl‑1,1,3,3‑tetramethylguanidine  
  • Quantitative data for tetramethylguanidines show conjugate acid pKa’s around ~13–14 (in acetonitrile), which is distinctly higher than the bicyclic amidine. The exact numbers in a physicochemical database would show, for example, pKa ≈13.6; this numerical difference is evidence enough to make a distinct group.

• Group 3 (“Superbasic”):  
 – N‑[dimethylamino‑ethylimino‑[[tris(dimethylamino)‑λ⁵‐phosphanylidene]amino]‑λ⁵‐phosphanyl]‑N‑methylmethanamine  
  • This kind of polyaminophosphazene derivative is known from quantitative measurements to have exceptionally high basicities (conjugate acid pKa’s often exceeding 30 in aprotic media). In a database, measured values in the 30+ range (or even higher) would be the quantitative justification for a separate “superbase” group.

In summary, using a measured property such as pKa (from a comprehensive database) to classify by basicity:  
– Group 1 (pKa ~11–12): the bicyclic amidine  
– Group 2 (pKa ~13–14): the tetramethylguanidine  
– Group 3 (pKa >30): the phosphazene‐type superbase

This classification relies on direct quantitative values for pKa (or equivalent measures of proton affinity) rather than general chemical intuition, and it clearly divides the three candidate base substances into three quantitatively distinct groups.