import json

def parse_ligand_data(json_data):
    """
    解析JSON格式的配体数据并格式化输出
    """
    ligands = json.loads(json_data)
    # save ligands to json file
    with open("ligands.json", "w") as f:
        # solve unicode error
        json.dump(ligands, f, indent=4, ensure_ascii=False)

# 示例使用
if __name__ == "__main__":
    json_str = '''[\n  {\n    \"name\": \"Xantphos\",\n    \"electronic\": \"TEP \u2248 2064 cm\u207b\u00b9; moderate electron donor, wide bite angle, favors \u03c0-backbonding\",\n    \"steric\": \"Cone angle per phosphorus: 110\u2013120\u00b0; very bulky, rigid bidentate ligand\",\n    \"lability_denticity\": \"Bidentate (chelating diphosphine); low lability due to strong chelation\"\n  },\n  {\n    \"name\": \"dtbpf\",\n    \"electronic\": \"TEP: 2054 cm\u207b\u00b9; very strong electron donor via tert-butylphosphino groups\",\n    \"steric\": \"Very bulky due to tert-butyl groups, cone angle per phosphorus: 165\u2013170\u00b0\",\n    \"lability_denticity\": \"Bidentate (ferrocene backbone); moderate flexibility and strong chelation\"\n  },\n  {\n    \"name\": \"P(Ph)3\",\n    \"electronic\": \"TEP: 2068.9 cm\u207b\u00b9; moderate \u03c3-donor, weak \u03c0-acceptor\",\n    \"steric\": \"Cone angle: 145\u00b0; moderate steric bulk\",\n    \"lability_denticity\": \"Monodentate; high lability, easily dissociates\"\n  },\n  {\n    \"name\": \"XPhos\",\n    \"electronic\": \"TEP: 2056 cm\u207b\u00b9; very strong electron donor (dialkylarylphosphine)\",\n    \"steric\": \"Extremely bulky, cone angle: 206\u00b0\",\n    \"lability_denticity\": \"Monodentate; moderate lability\"\n  },\n  {\n    \"name\": \"P(tBu)3\",\n    \"electronic\": \"TEP: 2056 cm\u207b\u00b9; one of the strongest electron donors\",\n    \"steric\": \"Extremely bulky, cone angle: 182\u00b0\",\n    \"lability_denticity\": \"Monodentate; very high lability, very poor chelation\"\n  },\n  {\n    \"name\": \"CataCXium A\",\n    \"electronic\": \"TEP: unknown (expected 2050\u20132058 cm\u207b\u00b9); very strong \u03c3-donor\",\n    \"steric\": \"Very bulky, cone angle less than 200\u00b0\",\n    \"lability_denticity\": \"Monodentate; moderate lability\"\n  },\n  {\n    \"name\": \"P(Cy)3\",\n    \"electronic\": \"TEP: 2056 cm\u207b\u00b9; strong electron donor\",\n    \"steric\": \"Bulky, cone angle: 170\u00b0\",\n    \"lability_denticity\": \"Monodentate; highly labile\"\n  },\n  {\n    \"name\": \"dppf\",\n    \"electronic\": \"TEP: 2068 cm\u207b\u00b9; moderate donor, diaryl-type\",\n    \"steric\": \"Cone angle per phosphorus: less than 120\u00b0; less bulky than Xantphos\",\n    \"lability_denticity\": \"Bidentate (chelating diphosphine); moderate flexibility, low lability\"\n  },\n  {\n    \"name\": \"nothing\",\n    \"electronic\": \"N/A\",\n    \"steric\": \"N/A\",\n    \"lability_denticity\": \"N/A\"\n  },\n  {\n    \"name\": \"AmPhos\",\n    \"electronic\": \"TEP: 2055 cm\u207b\u00b9; electron-rich, strong \u03c3-donor\",\n    \"steric\": \"Bulky tert-butyl groups, cone angle \u2248 164\u00b0\",\n    \"lability_denticity\": \"Monodentate; high lability\"\n  },\n  {\n    \"name\": \"SPhos\",\n    \"electronic\": \"TEP: 2057 cm\u207b\u00b9; strong \u03c3-donor, dialkylarylphosphine\",\n    \"steric\": \"Exceptionally bulky, cone angle: 210\u00b0\",\n    \"lability_denticity\": \"Monodentate; moderate to high lability\"\n  },\n  {\n    \"name\": \"P(o-Tol)3\",\n    \"electronic\": \"TEP: 2066 cm\u207b\u00b9; slightly stronger donor than PPh3\",\n    \"steric\": \"Cone angle: 194\u00b0; significantly larger than PPh3\",\n    \"lability_denticity\": \"Monodentate; moderate lability\"\n  }\n]'''
    
    parse_ligand_data(json_str)