# 数据集介绍

#### 1. 大语言模型（LLM）预训练数据集

预训练阶段所采用的Pistachio数据集是一个大规模反应信息库。其数据主体是通过自动化文本挖掘技术，从美国专利（USPTO）和欧洲专利（EPO）的全文中系统性提取的。为扩充数据多样性与精确性，该数据集还整合了多种来源的信息，包括直接从专利文献中嵌入的ChemDraw (CDX) 文件中解析的结构化数据、来自Reaxys等专业化学数据库的记录，以及部分电子实验记录本（ELN）的导出数据。该数据集总共包含1917万条化学反应，在本项目中，我们主要利用其反应SMILES字符串进行模型预训练。

#### 2. 大语言模型（LLM）微调基准数据集

为了对模型性能进行严格且无偏的评估，我们选取了一系列在化学反应优化领域被广泛应用的公开基准数据集。这些数据集的核心优势在于其数据的完备性（completeness），即它们均通过高通量自动化实验平台生成，并涵盖了在明确定义的化学空间内所有变量组合的实验结果（全因子设计）。这种详尽的覆盖方式有效排除了采样偏差，使得我们能够基于已知的实验真值，对算法的推荐性能进行确定性的定量评估。

具体而言，我们采用了三个公认的基准数据集：Suzuki偶联、C-H芳基化（Arylation）以及Buchwald-Hartwig偶联反应。在微调阶段，我们从每个数据集中随机抽取1%的数据作为训练样本，以调整个预训练模型。

   Suzuki 数据集: 该数据集源于Perera等人于2018年报道的自动化纳摩尔级流动筛选研究。实验的化学空间由4种卤代喹啉、3种硼酸衍生物、11种膦配体、7种碱和4种溶剂的全因子组合构成。所有反应均在统一的条件（100 °C, 1分钟停留时间, 9:1 有机相/水相）下进行。反应收率通过双UPLC-MS在线检测并进行了统一校正，数据完整且一致性高，是领域内广为采纳的验证标准之一。

   Arylation 数据集: 该数据集由Shields等人在2021年报道，用于贝叶斯优化研究。其化学空间由12种膦配体、4种碱、4种溶剂、3个温度梯度和3个浓度梯度的完全交叉设计生成。所有实验均在96孔板中高通量完成，收率通过UHPLC-MS结合内标法进行精确定量。该数据集无重复、无删失，变量空间分布均匀，并经过了50位化学家的实战验证，是C-H官能化反应优化领域的重要基准。

   Buchwald-Hartwig 数据集: 该数据集由Ahneman等人于2018年发布，旨在通过机器学习预测C-N偶联反应的收率。实验采用1536孔板的纳摩尔级高通量形式，系统地考察了15种芳基卤代物、4种配体、3种碱与23种异噁唑添加剂的全部组合。所有反应在标准条件下（60 °C, DMSO, 16小时）进行，收率由LC-MS定量。该数据集数据完整，无缺失值，是研究添加剂效应和复杂反应体系建模的权威开放数据。

#### 3. 贝叶斯优化基准数据集

在贝叶斯优化任务中，我们使用了四个基准数据集：Suzuki、Arylation、Buchwald$_{\text{sub-1}}$ 和 Buchwald$_{\text{sub-2}}$。其中，后两者源于对上述Buchwald-Hartwig数据集的划分。为了保证优化空间内目标产物的一致性，原始数据集首先依据产物分子结构被划分为五个独立的子集。我们观察到这些子集的反应收率呈现明显的高产率和低产率两种模式。为确保评估的全面性，我们从这两类中各选择了一个代表性子集，分别命名为Buchwald$_{\text{sub-1}}$和Buchwald$_{\text{sub-2}}$。表1总结了这四个数据集的关键描述性统计数据，而图1则通过核密度估计（KDE）图直观地展示了它们各自的收率分布。这些数据集的统计特性各不相同，平均收率从18.71%到42.24%不等，分布形态多样，共同构成了一组具有挑战性的优化问题，能够有效检验算法在不同数据环境下的性能。



在我们的实验中，不同模块的参数设置如下：

在 Data-Driven 模块中，我们利用 $2 \times$ NVIDIA A800 GPUs 对回归模型进行微调。微调阶段的具体超参数设置为：学习率为 $1\times10^{-4}$，批量大小为 24。模型在从原始数据集中随机抽样的 1% 训练数据上，完成了 100 个周期的训练。

在 Knowledge-Driven 模块中，我们首先通过在 5 个不同的随机种子上独立运行优化过程来构建决策树，并将其性能指标的平均值作为最终评估结果，以确保模型的稳定性。随后，在贝叶斯优化阶段，我们设置了 40 次迭代，其中每次迭代会采样数据集规模的 0.1%。

值得注意的是，这些数据使用比例是经过充分验证的，其有效性已在章节 ~\ref{exp:data_volume} 和 ~\ref{exp:batch_size} 中得到证明。实验中使用的采集函数和其他相关配置与其他基线方法保持一致。更进一步的细节，如用于LLM聚类的提示词和训练设置，详见附录。










# limitations

对大型语言模型性能与知识库的依赖性： 本框架的性能与LLM的能力及知识库质量直接挂钩。LLM在解析文献和划分变量空间时的推理错误，或是针对特定反应的知识语料不足，都可能导致对搜索空间的次优分解，从而限制了整体的优化效率。
初始标记数据的偏差问题： 数据驱动策略对用于微调的初始小规模标记数据的代表性高度敏感。如果该初始子集存在偏差，未能覆盖高产率区域，则可能导致LLM回归器生成有偏的伪数据，从而误导优化过程的早期探索方向。
缺乏安全性和可行性约束： 当前框架的优化目标完全集中于性能指标，缺乏对实验安全性与物理可行性的内在约束。因此，ChemBOMAS可能会推荐理论上最优但实际操作中危险或不可行的反应条件，这要求在部署时必须结合专家监督或引入额外的安全评估模块。









删一个数据集

xyz

？？cite

npy数据

heat放补充材料

一堆UCB

实验细节


缺少 ab_batch
删bg
k-d d-d缩减，按其他的来
limit缩减

创新点，增加指标说明，比其他方法提高了x%，速度加快y%

\textbf{3.} ChemBOMAS significantly accelerates BO under limited data (1\% of all search space) on four chemical reaction datasets. It achieves accelerated convergence, superior final performance, and lower variance compared to multiple strong baseline methods, improving optimal results by approximately 3--10\% and converging about 2--5$\times$ faster.
