#!/usr/bin/env bash
# git-ap —— git add . && git commit -m "$msg" && git push gitee <branch>

set -e   # 任何一步失败立即退出

# 1. 检查参数
if [[ -z "$1" ]]; then
    echo "用法: $0 \"commit message\""
    exit 1
fi
commit_msg="$1"

# 2. 检查是否在 Git 仓库
if ! git rev-parse --is-inside-work-tree >/dev/null 2>&1; then
    echo "错误：当前目录不是 Git 仓库！"
    exit 1
fi

# 3. 获取当前分支名
branch=$(git rev-parse --abbrev-ref HEAD)

# 4. 依次执行
echo "→ git add ."
git add .

echo "→ git commit -m \"$commit_msg\""
git commit -m "$commit_msg"

echo "→ git push gitee $branch"
git push gitee "$branch"

echo "✅ 全部完成！已推送到 gitee/$branch"