mp = {
    "base": ["smiles", "basicity_pKa"],
    "ligand": ['electronic_properties', 'steric_bulk', 'smiles'],
    "solvent": ['dielectric_constant', 'water_miscibility', 'smiles']
}

save = 'name'

import json

json_path = ['openai_base.json', 'openai_ligand.json', 'openai_solvent.json']

for file_path in json_path:
    with open(file_path, 'r') as f:
        data = json.load(f)
    new_data = []
    for item in data:
        new_item = {}
        for k in mp[file_path.split('.')[0].split('_')[-1]]:
            new_item[k] = item[k]
        new_item[save] = item[save]
        new_data.append(new_item)
    with open(file_path, 'w') as f:
        json.dump(new_data, f, indent=4, ensure_ascii=False)
