import pandas as pd
import json, os

# 读取CSV文件
df = pd.read_csv('name_searchspace.csv')  # 替换为你的CSV文件路径

os.system("rm option*.json")

# 创建空字典存储结果
result = {}

# 遍历每一列
for column in df.columns:
    if column == "Yield":
        continue
    # 获取去重后的非空值，转换为列表并排序（按字母顺序）
    unique_values = df[column].dropna().unique().tolist()
    unique_values.sort()  # 如果需要按字母顺序排序
    
    # 将列名和对应的唯一值列表添加到结果字典中
    if len(unique_values) == 1:
        continue
    result[column] = unique_values

# 转换为JSON格式（确保中文字符正确显示）
json_output = json.dumps(result, indent=4, ensure_ascii=False)

# 如需保存到文件：
with open('options.json', 'w', encoding='utf-8') as f:
    f.write(json_output)