#!/usr/bin/env python3
"""
将当前目录下的 names.json 复制到父目录里所有以 buchwal 开头的子文件夹
（排除当前目录自身）。
"""
import shutil
from pathlib import Path

# 1. 定位文件与目录
src_file   = Path('names_maps.json').resolve()      # 当前目录下的 names.json
parent_dir = src_file.parent.parent            # 父目录
current_dir = src_file.parent                  # 当前目录

if not src_file.is_file():
    raise SystemExit('错误：当前目录下找不到 names_maps.json')

# 2. 遍历父目录下所有 buchwal* 文件夹
for folder in parent_dir.glob('buchwal*'):
    if not folder.is_dir():
        continue
    if folder.resolve() == current_dir:        # 排除当前目录
        continue

    dst = folder / 'names_maps.json'
    shutil.copy2(src_file, dst)                # 保留元数据
    print(f'已复制到 → {dst}')