import pandas as pd
import json

# 读取 CSV
df = pd.read_csv('name_searchspace.csv')

output = {}
for col in ['n', 'theta', 'r', 't']:
    unique_vals = df[col].dropna().unique()
    output[col] = unique_vals.tolist()

# save json
with open("options.json", "w") as f:
    json.dump(output, f, indent=2)