import pandas as pd
import json
csv_file = "searchspace_clean.csv"
df = pd.read_csv(csv_file)

json_file = "names_maps.json"
with open(json_file, "r") as f:
    names_maps = json.load(f)

df_2 = df.replace(names_maps)
df_2.to_csv("name_searchspace.csv", index=False)

output = {}
for col in ['frag_a', 'frag_b', 'frag_c']:
    unique_vals = df_2[col].dropna().unique()
    output[col] = unique_vals.tolist()

# save json
with open("options.json", "w") as f:
    json.dump(output, f, indent=2)