import pandas as pd
import json

# 读取 CSV
df = pd.read_csv('searchspace.csv')

# 保留指定列
cols_to_keep = [col for col in df.columns if col in {
    "drug_input","solid_lipid","solid_lipid_input","liquid_lipid_input","surfractant_input",'encap_efficiency'
}]

# 创建新 DataFrame
df_filtered = df[cols_to_keep]

# 保存为新文件
df_filtered.to_csv('name_searchspace.csv', index=False)

output = {}
for col in ["drug_input","solid_lipid","solid_lipid_input","liquid_lipid_input","surfractant_input"]:
    unique_vals = df_filtered[col].dropna().unique()
    output[col] = unique_vals.tolist()

# save json
with open("options.json", "w") as f:
    json.dump(output, f, indent=2)