#!/bin/bash
# 假设每个 *.csv 同名目录下都有 merge.py
# 如目录名与 csv 文件名完全一致（不含扩展名），直接 cd 进去执行

# 文件列表（按你给的顺序）
files=(
"buchwald_Cc1ccc(Nc2cccnc2)cc1.csv"
"buchwald_Cc1ccc(Nc2cccnc2)cc1.csv_0.5"
"buchwald_Cc1ccc(Nc2cccnc2)cc1.csv_0.25"
"buchwald_Cc1ccc(Nc2cccnc2)cc1.csv_2.0"
"buchwald_Cc1ccc(Nc2cccnc2)cc1.csv_4.0"
"buchwald_CCc1ccc(Nc2ccc(C)cc2)cc1.csv"
"buchwald_CCc1ccc(Nc2ccc(C)cc2)cc1.csv_0.5"
"buchwald_CCc1ccc(Nc2ccc(C)cc2)cc1.csv_0.25"
"buchwald_CCc1ccc(Nc2ccc(C)cc2)cc1.csv_2.0"
"buchwald_CCc1ccc(Nc2ccc(C)cc2)cc1.csv_4.0"
"buchwald_COc1ccc(Nc2ccc(C)cc2)cc1.csv_0.5"
"buchwald_COc1ccc(Nc2ccc(C)cc2)cc1.csv_0.25"
"buchwald_COc1ccc(Nc2ccc(C)cc2)cc1.csv_2.0"
"buchwald_COc1ccc(Nc2ccc(C)cc2)cc1.csv_4.0"
)

# 逐条处理
for name in "${files[@]}"; do
    dir="${name}"        # 去掉 .csv 得到目录名
    cd "$dir" && python merge.py
    wait
    cd ..
done