import pandas as pd
import json
import os

csv_files = [f for f in os.listdir('.') if f.startswith('buchwald')]

for folder in csv_files:
    csv_path = os.path.join(folder, 'searchspace.csv')
    df = pd.read_csv(csv_path)

    result = {}
    cols_to_drop = []

    for col in df.columns:
        if col == 'Yield':
            continue
        unique_vals = df[col].unique()
        if len(unique_vals) == 1:          # 只有一个可选项
            cols_to_drop.append(col)       # 记下待删除列
        else:
            result[col] = unique_vals.tolist()

    # 删除只有单一取值的列
    df = df.drop(columns=cols_to_drop)

    # 保存新的 options.json
    opt_path = os.path.join(folder, 'options_smiles_clean.json')
    with open(opt_path, 'w', encoding='utf-8') as f:
        json.dump(result, f, ensure_ascii=False, indent=4)

    # 如果需要把“去列后”的 DataFrame 存成新 CSV，可再写一行：
    df.to_csv(os.path.join(folder, 'searchspace_clean.csv'), index=False)