source /mnt/shared-storage-user/caipengxiang/workspace/ChemBOMAS/train_regression/env_volcengine.sh

# 定义所有数据集名称
DATA_NAMES=(
    # "grouped_exp_0.5"
    # "grouped_exp_0.25"
    # "grouped_exp_2.0"
    # "grouped_exp_4.0"
    # "suzuki_50_0.5"
    # "suzuki_50_0.25"
    # "suzuki_50_2.0"
    "suzuki_50_4.0"
    "arylation_0.5"
    "arylation_0.25"
    "arylation_2.0"
    "arylation_4.0"
)

# Pretrained
BASE_MODEL_DIR="/mnt/shared-storage-user/caipengxiang/H200-share/models/share/step1_llama3_8b_0916_yearly_pistachio_ep3"

latest="DD"

# 检查所需路径是否都存在
PROJECT_DIR="/mnt/shared-storage-user/caipengxiang/workspace/ChemBOMAS"
SAVE_RESULTS_DIR="/mnt/shared-storage-user/caipengxiang/H200-ai4chem/Exp_AB_results"

NOTES="cluster_config/method_notes.txt"

required_paths=(
    "${BASE_MODEL_DIR}"
    "${PROJECT_DIR}/train_regression/data4regression"
    "yield_ft_ds_config.json"
    "${SAVE_RESULTS_DIR}"
    "${NOTES}"
)

echo $latest

for path in "${required_paths[@]}"; do
    if [ ! -e "$path" ]; then
        echo "Error: Required path not found: $path"
        exit 1
    fi
done

export TOKENIZERS_PARALLELISM=false 

# 循环训练每个数据集
for DATA_NAME in "${DATA_NAMES[@]}"; do
    echo "Evaluating on dataset: ${DATA_NAME}"

    CHECKPOINT_DIR="/mnt/shared-storage-user/caipengxiang/H200-ai4chem/Exp_AB_results/share/llama-3.1-8B/clustered/${DATA_NAME}"

    deepspeed --num_nodes=${NNODES} \
            --num_gpus=${GPUS} \
            --master_addr=${MASTER_ADDR} \
            --master_port=${MASTER_PORT} \
            --node_rank=${RANK} \
            no_pretrain_sft_eval.py \
            --pretrained_model_path ${BASE_MODEL_DIR} \
            --searchspace_name ${DATA_NAME} \
            --lora 1 \
            --data_name ${DATA_NAME} \
            --batch_size 48 \
            --checkpoint_dir ${CHECKPOINT_DIR} \
            --log_file "exp_eval.log" \
            --pooling_method "last_token" \
            --cluster_config "cluster_config/cluster_config.yaml" \
            --load_by_torch 1 \
            --latest_method_notes "${latest}" \
            --buchwald_all 1
done